/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class SetMethodAnnotationValueValidator
implements IValueValidationRule {
    private static final String setMethod = NameUtile.getAsName((String)"setMethod");

    @Override
    public void validate(Node errorNode, Node target, Annotation annotation, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotation.getValue(setMethod) instanceof Function) {
            this.validateSetMethod(errorNode, target, (Function)annotation.getValue(setMethod), BindingUtil.getDeclaringPart(target), problemRequestor, compilerOptions);
        }
    }

    public void validateSetMethod(Node errorNode, Node target, Function function, Part declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        FunctionParameter binding;
        Part valueDeclarer = BindingUtil.getDeclaringPart((Member)function);
        if (valueDeclarer != null && !valueDeclarer.equals((Type)declaringPart).booleanValue()) {
            problemRequestor.acceptProblem(errorNode, 3461, new String[]{"getMethod", declaringPart.getCaseSensitiveName()});
        }
        if (function.getReturnType() != null) {
            problemRequestor.acceptProblem(errorNode, 3389, new String[]{function.getCaseSensitiveName(), "setMethod"});
        }
        if (function.getParameters().size() == 1 && (binding = (FunctionParameter)function.getParameters().get(0)).getParameterKind() != ParameterKind.PARM_IN) {
            problemRequestor.acceptProblem(errorNode, 3388, new String[]{function.getCaseSensitiveName(), "setMethod"});
        }
        final Type[] fieldType = new Type[1];
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                fieldType[0] = classDataDeclaration.getType().resolveType();
                return false;
            }
        };
        target.accept(visitor);
        if (fieldType[0] != null) {
            boolean error = false;
            if (function.getParameters().size() != 1) {
                error = true;
            } else {
                FunctionParameter binding2 = (FunctionParameter)function.getParameters().get(0);
                if (!fieldType[0].equals(binding2.getType()).booleanValue()) {
                    error = true;
                }
            }
            if (error) {
                problemRequestor.acceptProblem(errorNode, 3387, new String[]{function.getCaseSensitiveName(), "setMethod", BindingUtil.getShortTypeString(fieldType[0])});
            }
        }
    }
}

