/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.EnumerationEntry;

public class EnumerationValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    private List<Integer> alreadySeenValues;
    private boolean[] foundField = new boolean[1];

    public EnumerationValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Enumeration enumeration) {
        this.alreadySeenValues = new ArrayList<Integer>();
        this.foundField = new boolean[1];
        return true;
    }

    @Override
    public void endVisit(Enumeration enumeration) {
        if (!this.foundField[0]) {
            this.problemRequestor.acceptProblem((Node)enumeration, 3473, new String[]{enumeration.getIdentifier()});
        }
    }

    @Override
    public boolean visit(EnumerationField enumerationField) {
        this.foundField[0] = true;
        if (!this.validateValue(enumerationField)) {
            return false;
        }
        if (enumerationField.getName().resolveMember() != null) {
            EnumerationEntry enumBinding = (EnumerationEntry)enumerationField.getName().resolveMember();
            Integer value = new Integer(enumBinding.getValue());
            if (this.alreadySeenValues.contains(new Integer(enumBinding.getValue()))) {
                Expression node = enumerationField.getName();
                if (enumerationField.hasConstantValue()) {
                    node = enumerationField.getConstantValue();
                }
                this.problemRequestor.acceptProblem((Node)node, 3471, new String[]{value.toString(), ((org.eclipse.edt.mof.egl.Enumeration)enumBinding.getContainer()).getCaseSensitiveName()});
            } else {
                this.alreadySeenValues.add(value);
            }
        }
        return false;
    }

    private boolean validateValue(EnumerationField enumerationField) {
        if (enumerationField.hasConstantValue()) {
            Expression val = enumerationField.getConstantValue();
            while (val instanceof UnaryExpression) {
                val = ((UnaryExpression)val).getExpression();
            }
            if (val instanceof IntegerLiteral) {
                String value = ((IntegerLiteral)val).getValue();
                try {
                    Integer.valueOf(value);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.problemRequestor.acceptProblem((Node)enumerationField.getConstantValue(), 3470, new String[]{enumerationField.getConstantValue().getCanonicalString()});
            return false;
        }
        return true;
    }
}

