/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ClassDataDeclarationValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class ExternalTypeValidator
extends FunctionContainerValidator {
    IRPartBinding irBinding;
    ExternalType externalTypeBinding;
    org.eclipse.edt.compiler.core.ast.ExternalType externalType;

    public ExternalTypeValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, irBinding, compilerOptions);
        this.irBinding = irBinding;
        this.externalTypeBinding = (ExternalType)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ExternalType externalType) {
        this.externalType = externalType;
        EGLNameValidator.validate(externalType.getName(), 38, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(externalType);
        if (this.checkHasSubtype()) {
            this.checkExtendedTypes(this.externalTypeBinding.getStereotype().getEClass());
            this.checkCycles();
        }
        return true;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        classDataDeclaration.accept(new ClassDataDeclarationValidator(this.problemRequestor, this.compilerOptions, this.partBinding));
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        super.visit(nestedFunction);
        this.checkParameters(nestedFunction.getFunctionParameters());
        return false;
    }

    @Override
    public boolean visit(Constructor constructor) {
        super.visit(constructor);
        this.checkParameters(constructor.getParameters());
        return false;
    }

    private void checkParameters(List parameters) {
        EClass clazz;
        Stereotype subtype = this.externalTypeBinding.getStereotype();
        if (subtype != null && (clazz = subtype.getEClass()) != null && NameUtile.equals((String)clazz.getName(), (String)NameUtile.getAsName((String)"NativeType")) && NameUtile.equals((String)clazz.getPackageName(), (String)NameUtile.getAsName((String)"eglx.lang"))) {
            return;
        }
        for (FunctionParameter parm : parameters) {
            if (!parm.isParmConst()) continue;
            this.problemRequestor.acceptProblem((Node)parm, 4961, new String[]{parm.getName().getCanonicalName()});
        }
    }

    private void checkExtendedTypes(EClass expectedSubtype) {
        for (Name nameAST : this.externalType.getExtendedTypes()) {
            Type extendedType = nameAST.resolveType();
            if (extendedType == null || BindingUtil.isEClassProxy((Element)extendedType)) continue;
            if (!(extendedType instanceof ExternalType)) {
                this.problemRequestor.acceptProblem((Node)nameAST, 3421, new String[]{extendedType.getTypeSignature()});
                continue;
            }
            Stereotype superSubtype = ((ExternalType)extendedType).getStereotype();
            if (superSubtype != null && (expectedSubtype.equals(superSubtype.getEClass()) || this.isMofClass((ExternalType)extendedType))) continue;
            this.problemRequestor.acceptProblem((Node)nameAST, 3446, new String[]{extendedType.getTypeSignature()});
        }
    }

    private boolean isMofClass(ExternalType et) {
        if (BindingUtil.getAnnotationWithSimpleName((Element)et, "ClassType") != null) {
            return true;
        }
        return BindingUtil.getAnnotationWithSimpleName((Element)et, "MofClass") != null;
    }

    private boolean checkHasSubtype() {
        boolean subtypeValid;
        if (this.externalType.hasSubType()) {
            subtypeValid = this.externalTypeBinding.getStereotype() != null;
        } else {
            this.problemRequestor.acceptProblem((Node)this.externalType.getName(), 3420, new String[]{this.externalType.getName().getCanonicalName()});
            subtypeValid = false;
        }
        return subtypeValid;
    }

    private void checkCycles() {
        for (Name name : this.externalType.getExtendedTypes()) {
            Type type = name.resolveType();
            if (!(type instanceof ExternalType) || !this.checkCycles((ExternalType)type, new HashSet<ExternalType>())) continue;
            this.problemRequestor.acceptProblem((Node)name, 5045, new String[]{this.externalTypeBinding.getCaseSensitiveName(), name.toString()});
        }
    }

    private boolean checkCycles(ExternalType externalType, Set<ExternalType> seen) {
        if (seen.contains(externalType = (ExternalType)BindingUtil.realize((Part)externalType))) {
            return false;
        }
        if (this.externalTypeBinding.equals((Type)externalType).booleanValue()) {
            return true;
        }
        seen.add(externalType);
        for (StructPart superType : externalType.getSuperTypes()) {
            if (!(superType instanceof ExternalType) || !this.checkCycles((ExternalType)superType, seen)) continue;
            return true;
        }
        return false;
    }
}

