/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.ExpressionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.mof.utils.NameUtile;

public class ProgramValidator
extends FunctionContainerValidator {
    IRPartBinding irBinding;
    org.eclipse.edt.mof.egl.Program programBinding;
    Program program;

    public ProgramValidator(IProblemRequestor problemRequestor, IRPartBinding irBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, irBinding, compilerOptions);
        this.irBinding = irBinding;
        this.programBinding = (org.eclipse.edt.mof.egl.Program)irBinding.getIrPart();
    }

    @Override
    public boolean visit(Program aprogram) {
        this.program = aprogram;
        this.partNode = aprogram;
        EGLNameValidator.validate(this.program.getName(), 2, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(this.program);
        aprogram.accept(new ExpressionValidator(this.partBinding, this.problemRequestor, this.compilerOptions));
        this.validateProgramFunctions();
        return true;
    }

    protected void validateProgramFunctions() {
        this.program.accept(new AbstractASTVisitor(){
            boolean main = false;

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                if (NameUtile.equals((String)nestedFunction.getName().getCanonicalName(), (String)"main")) {
                    this.main = true;
                    if (nestedFunction.getFunctionParameters().size() > 0) {
                        ProgramValidator.this.problemRequestor.acceptProblem((Node)nestedFunction.getFunctionParameters().get(0), 4924, new String[]{ProgramValidator.this.program.getName().getCanonicalName()});
                    }
                }
                return false;
            }

            @Override
            public void endVisit(Program aprogram) {
                if (!this.main) {
                    ProgramValidator.this.problemRequestor.acceptProblem((Node)aprogram.getName(), 4922, new String[]{aprogram.getName().getCanonicalName()});
                }
            }
        });
    }
}

