/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ServiceInterfaceValidatorUtil {
    public static void validateParametersAndReturn(final NestedFunction nestedFunction, final IProblemRequestor problemRequestor) {
        if (!(nestedFunction.getName().resolveMember() instanceof Function)) {
            return;
        }
        nestedFunction.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionParameter functionParameter) {
                Type typeBinding;
                if (functionParameter.isParmConst()) {
                    problemRequestor.acceptProblem((Node)functionParameter, 4962, new String[]{functionParameter.getName().getCanonicalName(), nestedFunction.getName().getCanonicalName()});
                }
                if ((typeBinding = functionParameter.getType().resolveType()) != null) {
                    if (!ServiceInterfaceValidatorUtil.isTypeValidInServicesAndProxy(typeBinding)) {
                        problemRequestor.acceptProblem((Node)functionParameter.getType(), 7804, new String[]{typeBinding.getTypeSignature()});
                    }
                    if (functionParameter.getName().resolveMember() instanceof Field) {
                        problemRequestor.acceptProblem(functionParameter, 7806);
                    }
                }
                return false;
            }

            @Override
            public void endVisit(NestedFunction nestedFunction2) {
                Type typeBinding;
                if (nestedFunction2.hasReturnType() && (typeBinding = nestedFunction2.getReturnType().resolveType()) != null && !ServiceInterfaceValidatorUtil.isTypeValidInServicesAndProxy(typeBinding)) {
                    problemRequestor.acceptProblem((Node)nestedFunction2.getReturnType(), 7805, new String[]{typeBinding.getTypeSignature()});
                }
            }
        });
    }

    public static boolean isTypeValidInServicesAndProxy(Type typeBinding) {
        return TypeUtils.isTextType((Type)typeBinding) || TypeUtils.isNumericType((Type)typeBinding) || typeBinding != null && typeBinding.getClassifier() instanceof EGLClass && (typeBinding.getClassifier().equals(TypeUtils.Type_DATE) != false || typeBinding.getClassifier().equals(TypeUtils.Type_TIME) != false || typeBinding.getClassifier().equals(TypeUtils.Type_TIMESTAMP) != false || typeBinding.getClassifier().equals(TypeUtils.Type_BOOLEAN) != false) || typeBinding instanceof ArrayType && ServiceInterfaceValidatorUtil.isTypeValidInServicesAndProxy(((ArrayType)typeBinding).getElementType()) || typeBinding instanceof Record || typeBinding instanceof Handler || TypeUtils.isTypeOrSubtypeOf((Type)typeBinding, (String)"egl:eglx.lang.AnyException");
    }
}

