/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IsNotExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class CaseStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;

    public CaseStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(final CaseStatement caseStatement) {
        caseStatement.accept(new DefaultASTVisitor(){
            boolean visitingWhenClause = false;

            @Override
            public boolean visit(CaseStatement caseStatement) {
                return true;
            }

            @Override
            public boolean visit(WhenClause whenClause) {
                this.visitingWhenClause = true;
                return true;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                CaseStatementValidator.this.problemRequestor.acceptProblem(setValuesExpression, this.visitingWhenClause ? 7514 : 7513);
                return true;
            }
        });
        for (WhenClause whenClause : caseStatement.getWhenClauses()) {
            for (Expression expression : whenClause.getExpr_plus()) {
                expression.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visit(IsNotExpression isNotExpression) {
                        return false;
                    }

                    @Override
                    public boolean visit(SetValuesExpression setValuesExpression) {
                        return false;
                    }

                    @Override
                    public boolean visitExpression(Expression expr) {
                        Type binding = expr.resolveType();
                        if (binding != null) {
                            boolean criterionExisits;
                            binding = BindingUtil.resolveGenericType(binding, expr);
                            boolean bl = criterionExisits = caseStatement.getCriterion() != null && caseStatement.getCriterion().resolveType() != null;
                            if (!criterionExisits) {
                                if (!TypeUtils.Type_BOOLEAN.equals(binding).booleanValue()) {
                                    CaseStatementValidator.this.problemRequestor.acceptProblem(expr, 5078);
                                }
                            } else {
                                Type criterionType = caseStatement.getCriterion().resolveType();
                                boolean compatible = BindingUtil.isMoveCompatible(criterionType = BindingUtil.resolveGenericType(criterionType, caseStatement.getCriterion()), caseStatement.getCriterion().resolveMember(), binding, expr);
                                if (!compatible) {
                                    CaseStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 5089, new String[]{expr.getCanonicalString(), caseStatement.getCriterion().getCanonicalString()});
                                }
                            }
                        }
                        return false;
                    }
                });
            }
        }
        return false;
    }
}

