/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ForStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;

    public ForStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(final ForStatement forStatement) {
        forStatement.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expr) {
                HashMap<Expression, Type> rhsExprMap = new HashMap<Expression, Type>();
                TypeValidator.collectExprsForTypeCompatibility(expr, rhsExprMap);
                for (Map.Entry entry : rhsExprMap.entrySet()) {
                    Type tBinding = (Type)entry.getValue();
                    if (tBinding == null || IRUtils.isMoveCompatible((Type)TypeUtils.Type_INT, (Type)tBinding, (Member)((Expression)entry.getKey()).resolveMember())) continue;
                    if (expr == forStatement.getCounterVariable() || expr == forStatement.getVariableDeclarationName()) {
                        ForStatementValidator.this.problemRequestor.acceptProblem((Node)entry.getKey(), 5035);
                        continue;
                    }
                    String insert = "";
                    if (expr == forStatement.getFromIndex()) {
                        insert = "start";
                    } else if (expr == forStatement.getEndIndex()) {
                        insert = "end";
                    } else if (expr == forStatement.getDeltaExpression()) {
                        insert = "delta";
                    }
                    if (insert.length() <= 0) continue;
                    ForStatementValidator.this.problemRequestor.acceptProblem((Node)entry.getKey(), 5036, new String[]{insert});
                }
                return false;
            }
        });
        return false;
    }
}

