/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.compile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.utils.SoftLRUCache;
import org.eclipse.edt.compiler.internal.sdk.utils.Util;
import org.eclipse.edt.mof.utils.NameUtile;

public class ASTManager {
    private SoftLRUCache fileLRUCache = new SoftLRUCache(10);
    private static final int MAX_NUM_FILES = 10;
    private static final ASTManager INSTANCE = new ASTManager();

    private ASTManager() {
    }

    public static ASTManager getInstance() {
        return INSTANCE;
    }

    public org.eclipse.edt.compiler.core.ast.File getFileAST(File file) {
        org.eclipse.edt.compiler.core.ast.File cachedFile = (org.eclipse.edt.compiler.core.ast.File)this.fileLRUCache.get(file);
        if (cachedFile == null) {
            try {
                ErrorCorrectingParser parser = new ErrorCorrectingParser(new Lexer(new BufferedInputStream(new FileInputStream(file))));
                cachedFile = (org.eclipse.edt.compiler.core.ast.File)parser.parse().value;
                this.fileLRUCache.put(file, cachedFile);
            }
            catch (Exception e) {
                throw new BuildException(e);
            }
        }
        return cachedFile;
    }

    public Part getPartAST(File declaringFile, String partName) {
        org.eclipse.edt.compiler.core.ast.File file = this.getFileAST(declaringFile);
        List parts = file.getParts();
        for (Part part : parts) {
            if (!NameUtile.equals((String)part.getIdentifier(), (String)partName)) continue;
            return part.clonePart();
        }
        throw new RuntimeException("Part must exist before calling this method");
    }

    public Node getAST(File declaringFile, String partName) {
        if (NameUtile.equals((String)Util.getFilePartName(declaringFile), (String)partName)) {
            return this.getFilePartAST(declaringFile);
        }
        return this.getPartAST(declaringFile, partName);
    }

    private Node getFilePartAST(File declaringFile) {
        return this.getFileAST(declaringFile).cloneFilePart();
    }

    public void reset() {
        this.fileLRUCache = new SoftLRUCache(10);
    }
}

