/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.edt.compiler.internal.interfaces.IEGLMessageContributor;
import org.eclipse.edt.compiler.internal.interfaces.IEGLNestedMessageContributor;
import org.eclipse.edt.compiler.internal.interfaces.IEGLStatementNode;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;

public class EGLMessage
implements IGenerationResultsMessage {
    protected int severity = 0;
    private String id = null;
    private String[] params = null;
    private String groupName = null;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private int endOffset = 0;
    private int startOffset = 0;
    private IEGLMessageContributor messageContributor;
    private int startColumnNumber = 0;
    private int endColumnNumber = 0;
    private String builtMessage;
    private static ResourceBundle messageBundle;
    private String partName;
    private static final MessageFormat formatter;
    public static final int EGL_ERROR_MESSAGE = 1;
    public static final int EGL_WARNING_MESSAGE = 2;
    public static final int EGL_INFORMATIONAL_MESSAGE = 3;
    public static final String EGLMESSAGE_GROUP_VALIDATION = "Validation";
    public static final String EGLMESSAGE_GROUP_DEPLOYMENT = "Deployment";
    public static final String EGLMESSAGE_GROUP_EDITOR = "Editor";
    public static final String EGLMESSAGE_GROUP_STATEMENT_PARSER = "StatementParser";
    public static final String EGLMESSAGE_GROUP_SYNTAX = "Syntax";
    public static final String EGLMESSAGE_INVALID_NAME_LENGTH = "3001";
    public static final String EGLMESSAGE_INVALID_CHARACTER_IN_NAME = "3002";
    public static final String EGLMESSAGE_EZE_NOT_ALLOWED = "3003";
    public static final String EGLMESSAGE_RESERVED_WORD_NOT_ALLOWED = "3019";
    public static final String EGLMESSAGE_INFO_UNSUPPORTED_SQL_TYPE_ON_RETRIEVE = "4584";
    public static final String EGLMESSAGE_INFO_DECIMAL_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4585";
    public static final String EGLMESSAGE_INFO_DECIMAL_DECIMALS_SHORTENED_FROM_ON_RETRIEVE = "4586";
    public static final String EGLMESSAGE_INFO_HEX_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4587";
    public static final String EGLMESSAGE_INFO_INVALID_LENGTH_SET_TO_ZERO_ON_RETRIEVE = "4589";
    public static final String EGLMESSAGE_INFO_CHAR_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4590";
    public static final String EGLMESSAGE_INFO_DBCHAR_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4591";
    public static final String EGLMESSAGE_INFO_UNICODE_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4592";
    public static final String EGLMESSAGE_INFO_INVALID_DECIMALS_SET_TO_ZERO_ON_RETRIEVE = "4593";
    public static final String EGL_DEPLOYMENT_DEPLOYING_RUIHANDLER = "8303";
    public static final String EGL_DEPLOYMENT_COMPLETE = "8304";
    public static final String EGL_DEPLOYMENT_FAILED = "8305";
    public static final String EGL_DEPLOYMENT_EXCEPTION = "8306";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_NLS_FILE = "8307";
    public static final String EGL_DEPLOYMENT_FAILED_LOCATE_NLS_FILE = "8308";
    public static final String EGL_DEPLOYMENT_FAILED_LOCATE_EGLDD_FILE = "8310";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_HTML_FILE = "8312";
    public static final String EGL_DEPLOYMENT_DEPLOYED_PROPERTY_FILE = "8314";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_PROPERTY_FILE = "8315";
    public static final String EGL_DEPLOYMENT_DEPLOYED_BIND_FILE = "8316";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_RT_PROPERTY_FILE = "8318";
    public static final String EGL_DEPLOYMENT_DEPLOYED_RT_PROPERTY_FILE = "8319";
    public static final String EGL_DEPLOYMENT_DEPLOYED_HTML_FILE = "8320";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_PROPERTIES_FOLDER = "8325";
    public static final String EGL_DEPLOYMENT_LOCALE_PROCESSING_FAILED = "8326";
    public static final String EGL_DEPLOYMENT_CREATED_RESOURCE_REFS = "8329";
    public static final String EGL_DEPLOYMENT_FAILED_DEFINE_DATASOURCE = "8330";
    public static final String EGL_DEPLOYMENT_FAILED_WRITE_CONTEXTDOTXML = "8331";
    public static final String EGL_DEPLOYMENT_DEFINED_DATASOURCES = "8332";
    public static final String EGL_DEPLOYMENT_SERVER_NOT_TOMCAT = "8333";
    public static final String EGLMESSAGE_PARTNOTFOUND = "9001";
    public static final String EGLMESSAGE_COMPILE_ERRORS = "9991";
    public static final String EGLMESSAGE_GENERATION_FAILED = "9997";
    public static final String EGLMESSAGE_EXCEPTION_MESSAGE = "9998";
    public static final String EGLMESSAGE_EXCEPTION_STACKTRACE = "9999";

    static {
        formatter = new MessageFormat("");
    }

    public String getPartName() {
        return this.partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public EGLMessage(String aBundleName, int aSeverity, String anId, String groupName, Object messageContributor, String[] aParams, int aStartOffset, int anEndOffset) {
        this(ResourceBundle.getBundle(aBundleName, Locale.getDefault()), aSeverity, anId, groupName, messageContributor, aParams, aStartOffset, anEndOffset);
    }

    public EGLMessage(String aBundleName, int aSeverity, String anId, String groupName, Object messageContributor, String[] aParams, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        this(ResourceBundle.getBundle(aBundleName, Locale.getDefault()), aSeverity, anId, groupName, messageContributor, aParams, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public EGLMessage() {
    }

    public EGLMessage(ResourceBundle bundle, int aSeverity, String anId, String groupName, String[] aParams) {
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        messageBundle = bundle;
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
    }

    public EGLMessage(ResourceBundle aBundle, int aSeverity, String anId, String groupName, Object aMessageContributor, String[] aParams, int aStartOffset, int anEndOffset) {
        messageBundle = aBundle;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartOffset == -1 && mc.getStart() != null) {
                this.setStartLine(mc.getStart().getLine());
                this.setStartColumn(mc.getStart().getColumn());
                this.setStartOffset(mc.getStart().getOffset());
            }
            if (anEndOffset == -1 && mc.getEnd() != null) {
                this.setEndLine(mc.getEnd().getLine());
                this.setEndColumn(mc.getEnd().getColumn());
                this.setEndOffset(mc.getEnd().getOffset() + 1);
            }
        }
    }

    public EGLMessage(ResourceBundle aBundle, int aSeverity, String anId, String groupName, Object aMessageContributor, String[] aParams, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        int aStartOffset = 0;
        int anEndOffset = 0;
        messageBundle = aBundle;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartLine == -1 && mc.getStart() != null) {
                aStartLine = mc.getStart().getLine();
                aStartColumn = mc.getStart().getColumn();
                aStartOffset = mc.getStart().getOffset();
            }
            if (anEndLine == -1 && mc.getEnd() != null) {
                anEndLine = mc.getEnd().getLine();
                anEndColumn = mc.getEnd().getColumn();
                anEndOffset = mc.getEnd().getOffset() + 1;
            }
        }
        this.setStartLine(aStartLine);
        this.setStartColumn(aStartColumn);
        this.setEndLine(anEndLine);
        this.setEndColumn(anEndColumn);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
    }

    public EGLMessage(String aBundle, int aSeverity, String anId, String groupName, Object aMessageContributor, String[] aParams, int aStartLine, int aStartColumn, int aStartOffset, int anEndLine, int anEndColumn, int anEndOffset) {
        messageBundle = ResourceBundle.getBundle(aBundle, Locale.getDefault());
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartLine == -1 && mc.getStart() != null) {
                aStartLine = mc.getStart().getLine();
                aStartColumn = mc.getStart().getColumn();
                aStartOffset = mc.getStart().getOffset();
            }
            if (anEndLine == -1 && mc.getEnd() != null) {
                anEndLine = mc.getEnd().getLine();
                anEndColumn = mc.getEnd().getColumn();
                anEndOffset = mc.getEnd().getOffset() + 1;
            }
        }
        this.setStartLine(aStartLine);
        this.setStartColumn(aStartColumn);
        this.setEndLine(anEndLine);
        this.setEndColumn(anEndColumn);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
    }

    public static String buildMessageText(String key, Object[] inserts) {
        try {
            String message = messageBundle.getString(key);
            if (message == null || inserts == null || inserts.length == 0) {
                return message;
            }
            formatter.applyPattern(message);
            return formatter.format(EGLMessage.insertsWithoutNulls(inserts));
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static Object[] insertsWithoutNulls(Object[] originalInserts) {
        int numberInserts = originalInserts.length;
        Object[] newInserts = new Object[numberInserts];
        int i = 0;
        while (i < numberInserts) {
            newInserts[i] = originalInserts[i] != null ? originalInserts[i] : "";
            ++i;
        }
        return newInserts;
    }

    public static EGLMessage createEGLEditorErrorMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_EDITOR, new String[1]);
    }

    public static EGLMessage createEGLEditorErrorMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_EDITOR, inserts);
    }

    public static EGLMessage createEGLEditorErrorMessage(ResourceBundle resource, String messageID, String insert) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_EDITOR, new String[]{insert});
    }

    public static EGLMessage createEGLEditorInformationalMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 3, messageID, EGLMESSAGE_GROUP_EDITOR, new String[1]);
    }

    public static EGLMessage createEGLEditorInformationalMessage(ResourceBundle resource, String messageID, String insert) {
        return new EGLMessage(resource, 3, messageID, EGLMESSAGE_GROUP_EDITOR, new String[]{insert});
    }

    public static EGLMessage createEGLEditorInformationalMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 3, messageID, EGLMESSAGE_GROUP_EDITOR, inserts);
    }

    public static EGLMessage createEGLEditorWarningMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_EDITOR, new String[1]);
    }

    public static EGLMessage createEGLEditorWarningMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_EDITOR, inserts);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[1], -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLDeploymentErrorMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_DEPLOYMENT, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLDeploymentInformationalMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_DEPLOYMENT, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartColumn) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartLine, aStartColumn, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public static EGLMessage createEGLValidationPartErrorMessage(ResourceBundle resource, String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts, IEGLStatementNode node) {
        EGLMessage message = new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, node.getStartLine(), node.getStartColumn(), node.getEndLine(), node.getEndColumn());
        message.setStartOffset(node.getStartOffset());
        message.setEndOffset(node.getEndOffset() + 1);
        return message;
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String insert, int aStartOffset, int anEndOffset) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLValidationErrorMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String insert, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public static EGLMessage createEGLValidationInformationalMessage(String messageID, Object messageContributor) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[1], 1, 1, -1, -1);
    }

    public static EGLMessage createEGLValidationInformationalMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, 1, 1, -1, -1);
    }

    public static EGLMessage createEGLValidationInformationalMessage(String messageID, Object messageContributor, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, 1, 1, -1, -1);
    }

    public static EGLMessage createEGLValidationWarningMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLValidationWarningMessage(String messageID, Object messageContributor) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[1], -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationWarningMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationWarningMessage(String messageID, Object messageContributor, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLSytaxErrorMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 1, messageID, EGLMESSAGE_GROUP_SYNTAX, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLSyntaxWarningMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 2, messageID, EGLMESSAGE_GROUP_SYNTAX, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    @Override
    public String getBuiltMessage() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " " + this.startLineNumber + "/" + this.startColumnNumber + " " + this.builtMessage;
    }

    public String getBuiltMessageWithoutLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " " + this.builtMessage;
    }

    @Override
    public String getBuiltMessageWithLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        if (this.messageContributor instanceof IEGLMessageContributor && this.messageContributor.getResourceName() != null) {
            return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " - " + this.messageContributor.getResourceName() + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
        }
        return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
    }

    public int getEndColumn() {
        return this.endColumnNumber;
    }

    public int getEndLine() {
        return this.endLineNumber;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isSyntaxMessage() {
        return this.groupName.equals(EGLMESSAGE_GROUP_SYNTAX);
    }

    public String getMessagePrefix() {
        if (this.groupName.equals(EGLMESSAGE_GROUP_VALIDATION)) {
            return "VAL";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_STATEMENT_PARSER)) {
            return "EGL";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_EDITOR)) {
            return "EDT";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_SYNTAX)) {
            return "SYN";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_DEPLOYMENT)) {
            return "DEP";
        }
        return "XXX";
    }

    public Object getMessageContributor() {
        return this.messageContributor;
    }

    public static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(EGLMessage.getResourceBundleName());
    }

    public static String getResourceBundleName() {
        return "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    }

    public static String getResourceString(String key) {
        try {
            return EGLMessage.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public int getStartColumn() {
        return this.startColumnNumber;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public int getStartLine() {
        return this.startLineNumber;
    }

    public static String getValidationResourceBundleName() {
        return "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    }

    @Override
    public boolean isError() {
        return this.getSeverity() == 1;
    }

    @Override
    public boolean isInformational() {
        return this.getSeverity() == 3;
    }

    @Override
    public boolean isWarning() {
        return this.getSeverity() == 2;
    }

    public String primGetBuiltMessage() {
        return this.builtMessage;
    }

    public void setBuiltMessage(String msgText) {
        this.builtMessage = msgText;
    }

    public void setEndColumn(int newColumnNumber) {
        this.endColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setEndLine(int lineNumber) {
        this.endLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public void setMessageContributor(IEGLMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setMessageContributor(IEGLNestedMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setStartColumn(int newColumnNumber) {
        this.startColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setStartLine(int lineNumber) {
        this.startLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset < 0 ? 0 : offset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset < 0 ? 0 : offset;
    }

    public String toString() {
        return String.valueOf(this.getId()) + ": " + this.builtMessage;
    }

    public String[] getParams() {
        return this.params;
    }

    @Override
    public String getResourceName() {
        if (this.getMessageContributor() instanceof IEGLMessageContributor) {
            return ((IEGLMessageContributor)this.getMessageContributor()).getResourceName();
        }
        return null;
    }
}

