/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.internal.util.NameUtil;

public class EglarUtil {
    public static final String EDT_JAR_EXTENSION = ".eglar";
    public static final String EDT_MOF_EXTENSION = ".mofar";

    public static List<File> getAllSystemEglars(ICompiler compiler) {
        ArrayList<File> list = new ArrayList<File>();
        if (compiler == null || compiler.getSystemEnvironmentPath() == null) {
            return list;
        }
        String pathEntries = compiler.getSystemEnvironmentPath();
        String[] paths = NameUtil.toStringArray(pathEntries, File.pathSeparator);
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            list.addAll(EglarUtil.getAllEglarsInPath(path));
            ++i;
        }
        return list;
    }

    public static List<File> getAllEglarsInPath(String path) {
        File libfolder = new File(path);
        ArrayList<File> list = new ArrayList<File>();
        if (libfolder.exists() && libfolder.isDirectory()) {
            File[] files = libfolder.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile() && (file.getName().endsWith(EDT_JAR_EXTENSION) || file.getName().endsWith(EDT_MOF_EXTENSION))) {
                    list.add(file);
                }
                ++i;
            }
        }
        return list;
    }
}

