/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.tools;

public class IRUtils {
    public static final char[] SUFFIX_eglxml = ".eglxml".toCharArray();
    public static final char[] SUFFIX_EGLXML = ".EGLXML".toCharArray();
    public static final char[] SUFFIX_eglbin = ".eglbin".toCharArray();
    public static final char[] SUFFIX_EGLBIN = ".EGLBIN".toCharArray();
    public static final char[] SUFFIX_mofxml = ".mofxml".toCharArray();
    public static final char[] SUFFIX_MOFXML = ".MOFXML".toCharArray();
    public static final char[] SUFFIX_mofbin = ".mofbin".toCharArray();
    public static final char[] SUFFIX_MOFBIN = ".MOFBIN".toCharArray();

    public static boolean isEGLIRFileName(String name) {
        if (name == null) {
            return false;
        }
        return IRUtils.matchesFileName(name, SUFFIX_eglxml, SUFFIX_EGLXML) || IRUtils.matchesFileName(name, SUFFIX_eglbin, SUFFIX_EGLBIN) || IRUtils.matchesFileName(name, SUFFIX_mofxml, SUFFIX_MOFXML) || IRUtils.matchesFileName(name, SUFFIX_mofbin, SUFFIX_MOFBIN);
    }

    public static final boolean matchesFileName(String name, char[] lowercaseExtension, char[] uppercaseExtension) {
        int suffixLength;
        int nameLength = name.length();
        if (nameLength < (suffixLength = lowercaseExtension.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != lowercaseExtension[i] && c != uppercaseExtension[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

