/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.model.BranchCategory;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.model.DateTagCategory;
import org.eclipse.team.internal.ccvs.ui.model.RemoteModule;
import org.eclipse.team.internal.ccvs.ui.model.VersionCategory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class RepositoryComparator
extends ViewerComparator {
    public static final int ORDER_BY_LABEL = 0;
    public static final int ORDER_BY_LOCATION = 1;
    public static final int ORDER_BY_HOST = 2;
    private int orderBy = 0;
    private boolean ascending = true;

    public RepositoryComparator(int order, boolean ascending) {
        this.orderBy = order;
        this.ascending = ascending;
    }

    public RepositoryComparator() {
    }

    public int getOrderBy() {
        return this.orderBy;
    }

    public void setOrder(int orderBy) {
        this.orderBy = orderBy;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public int category(Object element) {
        if (element instanceof ICVSRemoteFolder) {
            if (((ICVSRemoteFolder)element).isDefinedModule()) {
                return 7;
            }
            return 1;
        }
        if (element instanceof RemoteModule) {
            ICVSRemoteFolder folder;
            ICVSRemoteResource resource = ((RemoteModule)element).getCVSResource();
            if (resource instanceof ICVSRemoteFolder && (folder = (ICVSRemoteFolder)resource).isDefinedModule()) {
                return 7;
            }
            return 1;
        }
        if (element instanceof ICVSRemoteFile) {
            return 2;
        }
        if (element instanceof CVSTagElement) {
            CVSTagElement tagElement = (CVSTagElement)element;
            if (tagElement.getTag().getType() == 0) {
                return 0;
            }
            if (tagElement.getTag().getType() == 1) {
                return 4;
            }
            if (tagElement.getTag().getType() == 2) {
                return 5;
            }
            if (tagElement.getTag().getType() == 3) {
                return 6;
            }
            return 7;
        }
        if (element instanceof BranchCategory) {
            return 4;
        }
        if (element instanceof VersionCategory) {
            return 5;
        }
        if (element instanceof DateTagCategory) {
            return 6;
        }
        if (element instanceof PendingUpdateAdapter) {
            return 10000;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        int cat2;
        int cat1 = this.category(o1);
        if (cat1 != (cat2 = this.category(o2))) {
            return cat1 - cat2;
        }
        if (o1 instanceof CVSTagElement && o2 instanceof CVSTagElement) {
            CVSTag tag1 = ((CVSTagElement)o1).getTag();
            CVSTag tag2 = ((CVSTagElement)o2).getTag();
            if (tag1.getType() == 1) {
                return tag1.compareTo(tag2);
            }
            return -1 * tag1.compareTo(tag2);
        }
        if (o1 instanceof ICVSRemoteFolder && o2 instanceof ICVSRemoteFolder) {
            ICVSRemoteFolder f1 = (ICVSRemoteFolder)o1;
            ICVSRemoteFolder f2 = (ICVSRemoteFolder)o2;
            if (f1.getName().equals(f2.getName())) {
                return this.compare(f1, f2);
            }
        }
        if (o1 instanceof ICVSRepositoryLocation && o2 instanceof ICVSRepositoryLocation) {
            return ((ICVSRepositoryLocation)o1).getLocation(false).compareTo(((ICVSRepositoryLocation)o2).getLocation(false));
        }
        if (o1 instanceof RepositoryRoot && o2 instanceof RepositoryRoot) {
            RepositoryRoot rr1 = (RepositoryRoot)((Object)o1);
            RepositoryRoot rr2 = (RepositoryRoot)((Object)o2);
            ICVSRepositoryLocation rl1 = rr1.getRoot();
            ICVSRepositoryLocation rl2 = rr2.getRoot();
            int compareResult = 0;
            switch (this.orderBy) {
                case 2: {
                    compareResult = rl1.getHost().compareTo(rl2.getHost());
                    if (compareResult != 0) break;
                }
                case 1: {
                    compareResult = rl1.getLocation(false).compareTo(rl2.getLocation(false));
                    if (compareResult != 0) break;
                }
                default: {
                    compareResult = super.compare(viewer, o1, o2);
                }
            }
            return this.ascending ? compareResult : -compareResult;
        }
        return super.compare(viewer, o1, o2);
    }

    private int compare(ICVSRemoteFolder f1, ICVSRemoteFolder f2) {
        CVSTag tag1 = f1.getTag();
        CVSTag tag2 = f2.getTag();
        if (tag1 == null) {
            return 1;
        }
        if (tag2 == null) {
            return -1;
        }
        return tag2.compareTo(tag1);
    }
}

