/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400AbstractTime;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;

public class AS400Date
extends AS400AbstractTime {
    private static final long serialVersionUID = -2802488573427538664L;
    private java.sql.Date defaultValue_;
    private static Hashtable formatsMap_;
    public static final int FORMAT_MDY = 0;
    public static final int FORMAT_DMY = 1;
    public static final int FORMAT_YMD = 2;
    public static final int FORMAT_JUL = 3;
    public static final int FORMAT_ISO = 4;
    public static final int FORMAT_USA = 5;
    public static final int FORMAT_EUR = 6;
    public static final int FORMAT_JIS = 7;
    public static final int FORMAT_CYMD = 8;
    public static final int FORMAT_CMDY = 9;
    public static final int FORMAT_CDMY = 10;
    public static final int FORMAT_LONGJUL = 11;
    public static final int FORMAT_MY = 12;
    public static final int FORMAT_YM = 13;
    public static final int FORMAT_MYY = 14;
    public static final int FORMAT_YYM = 15;
    private static final int FORMAT_RANGE_MINIMUM = 0;
    private static final int FORMAT_RANGE_MAXIMUM = 15;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$com$ibm$as400$access$AS400Date;

    public AS400Date() {
        this(4);
    }

    public AS400Date(TimeZone timeZone) {
        this(timeZone, 4);
    }

    public AS400Date(int n) {
        this.setFormat(n, this.defaultSeparatorFor(n));
    }

    public AS400Date(TimeZone timeZone, int n) {
        super(timeZone);
        this.setFormat(n, this.defaultSeparatorFor(n));
    }

    public AS400Date(int n, Character c) {
        this();
        this.setFormat(n, c);
    }

    public AS400Date(TimeZone timeZone, int n, Character c) {
        this(timeZone);
        this.setFormat(n, c);
    }

    public Object getDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = new java.sql.Date(0L);
        }
        return this.defaultValue_;
    }

    public int getFormat() {
        return super.getFormat();
    }

    public Character getSeparator() {
        return super.getSeparator();
    }

    public int getInstanceType() {
        return 17;
    }

    public Class getJavaType() {
        return class$java$sql$Date == null ? (class$java$sql$Date = AS400Date.class$("java.sql.Date")) : class$java$sql$Date;
    }

    public void setFormat(int n) {
        super.setFormat(n, this.defaultSeparatorFor(n));
    }

    void setFormat(String string) {
        super.setFormat(AS400Date.toFormat(string));
    }

    void setSeparator(Character c) {
        super.setSeparator(c);
    }

    public void setFormat(int n, Character c) {
        super.setFormat(n, c);
    }

    public void setFormat(int n, char c) {
        super.setFormat(n, new Character(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getFormatsMap() {
        if (formatsMap_ == null) {
            Class clazz = class$com$ibm$as400$access$AS400Date == null ? (class$com$ibm$as400$access$AS400Date = AS400Date.class$("com.ibm.as400.access.AS400Date")) : class$com$ibm$as400$access$AS400Date;
            synchronized (clazz) {
                if (formatsMap_ == null) {
                    formatsMap_ = new Hashtable(12);
                    formatsMap_.put("MDY", new Integer(0));
                    formatsMap_.put("DMY", new Integer(1));
                    formatsMap_.put("YMD", new Integer(2));
                    formatsMap_.put("JUL", new Integer(3));
                    formatsMap_.put("ISO", new Integer(4));
                    formatsMap_.put("USA", new Integer(5));
                    formatsMap_.put("EUR", new Integer(6));
                    formatsMap_.put("JIS", new Integer(7));
                    formatsMap_.put("CYMD", new Integer(8));
                    formatsMap_.put("CMDY", new Integer(9));
                    formatsMap_.put("CDMY", new Integer(10));
                    formatsMap_.put("LONGJUL", new Integer(11));
                    formatsMap_.put("MY", new Integer(12));
                    formatsMap_.put("YM", new Integer(13));
                    formatsMap_.put("MYY", new Integer(14));
                    formatsMap_.put("YYM", new Integer(15));
                }
            }
        }
        return formatsMap_;
    }

    public static int toFormat(String string) {
        if (string == null || string.length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "AS400Date.toFormat(" + string + "): Returning default date format.");
            }
            return 4;
        }
        Integer n = (Integer)AS400Date.getFormatsMap().get(string.trim().toUpperCase());
        if (n == null) {
            throw new ExtendedIllegalArgumentException("format (" + string + ")", 2);
        }
        return n;
    }

    static boolean isYearWithinRange(int n, int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: {
                return n >= 1940 && n <= 2039;
            }
            case 8: 
            case 9: 
            case 10: {
                return n >= 1900 && n <= 2899;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                return n >= 1 && n <= 9999;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + n2);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        return super.toBytes(object, byArray, n);
    }

    public Object toObject(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("as400Value");
        }
        String string = this.getCharConverter().byteArrayToString(byArray, n, this.getLength());
        return this.parse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object object) {
        int n;
        int n2;
        java.sql.Date date;
        if (object == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            date = (java.sql.Date)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "javaValue is of type " + object.getClass().getName());
            throw classCastException;
        }
        Object object2 = this;
        synchronized (object2) {
            GregorianCalendar gregorianCalendar = this.getCalendar(date);
            n2 = gregorianCalendar.get(1);
            n = gregorianCalendar.get(0);
        }
        if (n == 0) {
            throw new ExtendedIllegalArgumentException("javaValue (era=0)", 4);
        }
        if (!AS400Date.isYearWithinRange(n2, this.getFormat())) {
            Trace.log(2, "Year " + n2 + " is outside the range of values for AS400Date format " + this.getFormat());
            throw new ExtendedIllegalArgumentException("javaValue (year=" + n2 + ")", 4);
        }
        object2 = this.getDateFormatter().format(date);
        object2 = this.addCenturyDigit((String)object2, date);
        return object2;
    }

    public java.sql.Date parse(String string) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        try {
            Integer n = AS400Date.parseCenturyDigit(string, this.getFormat());
            if (n != null) {
                string = string.substring(1);
            } else {
                n = this.disambiguateCentury(string);
            }
            Date date = this.getDateFormatter(n).parse(string);
            return new java.sql.Date(date.getTime());
        }
        catch (Exception exception) {
            Trace.log(2, exception.getMessage(), string);
            Trace.log(2, "Date string is expected to be in format: " + this.prependCentury(this.patternFor(this.getFormat(), this.getSeparator())));
            throw new ExtendedIllegalArgumentException("source (" + string + ")", 2);
        }
    }

    public static java.sql.Date parseXsdString(String string) {
        return AS400Date.parseXsdString(string, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static java.sql.Date parseXsdString(String string, TimeZone timeZone) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        try {
            Date date = AS400AbstractTime.getDateFormatterXSD(timeZone).parse(string);
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException parseException) {
            Trace.log(2, parseException.getMessage(), string);
            Trace.log(2, "Value is expected to be in standard XML Schema 'date' format: yyyy-MM-dd");
            throw new ExtendedIllegalArgumentException("source (" + string + ")", 2);
        }
    }

    public static String toXsdString(Object object) {
        return AS400Date.toXsdString(object, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static String toXsdString(Object object, TimeZone timeZone) {
        java.sql.Date date;
        if (object == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            date = (java.sql.Date)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "javaValue is of type " + object.getClass().getName());
            throw classCastException;
        }
        return AS400AbstractTime.getDateFormatterXSD(timeZone).format(date);
    }

    private String prependCentury(String string) {
        switch (this.getFormat()) {
            case 8: 
            case 9: 
            case 10: {
                return "C" + string;
            }
        }
        return string;
    }

    private String addCenturyDigit(String string, java.sql.Date date) {
        switch (this.getFormat()) {
            case 8: 
            case 9: 
            case 10: {
                int n = this.getCalendar(date).get(1);
                int n2 = n / 100 - 19;
                return Integer.toString(n2) + string;
            }
        }
        return string;
    }

    private Integer disambiguateCentury(String string) {
        int n;
        switch (this.getFormat()) {
            case 2: 
            case 3: 
            case 13: {
                n = 0;
                break;
            }
            case 12: {
                if (this.getSeparator() == null) {
                    n = 2;
                    break;
                }
                n = 3;
                break;
            }
            case 0: 
            case 1: {
                if (this.getSeparator() == null) {
                    n = 4;
                    break;
                }
                n = 6;
                break;
            }
            default: {
                return null;
            }
        }
        int n2 = Integer.parseInt(string.substring(n, n + 2));
        int n3 = n2 < 40 ? 1 : 0;
        return new Integer(n3);
    }

    static Integer parseCenturyDigit(String string, int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 10: {
                return Integer.valueOf(Character.toString(string.charAt(0)));
            }
        }
        return null;
    }

    String patternFor(int n, Character c) {
        String string = c == null ? "" : c.toString();
        switch (n) {
            case 12: {
                return "MM" + string + "yy";
            }
            case 13: {
                return "yy" + string + "MM";
            }
            case 14: {
                return "MM" + string + "yyyy";
            }
            case 15: {
                return "yyyy" + string + "MM";
            }
            case 0: {
                return "MM" + string + "dd" + string + "yy";
            }
            case 1: {
                return "dd" + string + "MM" + string + "yy";
            }
            case 2: {
                return "yy" + string + "MM" + string + "dd";
            }
            case 3: {
                return "yy" + string + "DDD";
            }
            case 4: 
            case 7: {
                return "yyyy" + string + "MM" + string + "dd";
            }
            case 5: {
                return "MM" + string + "dd" + string + "yyyy";
            }
            case 6: {
                return "dd" + string + "MM" + string + "yyyy";
            }
            case 8: {
                return "yy" + string + "MM" + string + "dd";
            }
            case 9: {
                return "MM" + string + "dd" + string + "yy";
            }
            case 10: {
                return "dd" + string + "MM" + string + "yy";
            }
            case 11: {
                return "yyyy" + string + "DDD";
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + n);
    }

    Character defaultSeparatorFor(int n) {
        if (!this.isValidFormat(n)) {
            throw new ExtendedIllegalArgumentException("format (" + n + ")", 2);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return AS400AbstractTime.SLASH;
            }
            case 4: 
            case 7: {
                return AS400AbstractTime.HYPHEN;
            }
            case 6: {
                return AS400AbstractTime.PERIOD;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + n);
    }

    boolean isValidFormat(int n) {
        return AS400Date.validateFormat(n);
    }

    public static boolean validateFormat(int n) {
        return n >= 0 && n <= 15;
    }

    public static int getByteLength(int n, Character c) {
        if (c == null) {
            switch (n) {
                case 12: 
                case 13: {
                    return 4;
                }
                case 0: 
                case 1: 
                case 2: 
                case 14: 
                case 15: {
                    return 6;
                }
                case 11: {
                    return 7;
                }
                case 3: {
                    return 5;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return 8;
                }
                case 8: 
                case 9: 
                case 10: {
                    return 7;
                }
            }
            throw new InternalErrorException(6, "Unrecognized format: " + n);
        }
        switch (n) {
            case 12: 
            case 13: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 14: 
            case 15: {
                return 7;
            }
            case 0: 
            case 1: 
            case 2: 
            case 11: {
                return 8;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 10;
            }
            case 8: 
            case 9: 
            case 10: {
                return 9;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + n);
    }

    int lengthFor(int n) {
        return AS400Date.getByteLength(n, this.getSeparator());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

