/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;

abstract class ConvTableDoubleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    char[] toUnicode_ = null;
    char[][] toUnicodeSurrogate_ = null;
    char[] fromUnicode_ = null;

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2, char[][] cArray3) {
        this(n, cArray, cArray2);
        this.toUnicodeSurrogate_ = new char[65535][];
        for (int i = 0; i < cArray3.length; ++i) {
            char[] cArray4 = new char[]{cArray3[i][1], cArray3[i][2]};
            this.toUnicodeSurrogate_[0xFFFF & cArray3[i][0]] = cArray4;
        }
    }

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.toUnicode_ = this.decompress(cArray);
        this.fromUnicode_ = this.decompress(cArray2);
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded double-byte map for ccsid: " + this.ccsid_);
        }
    }

    char[] decompress(char[] cArray) {
        if (Trace.traceOn_) {
            Trace.log(5, "Decompressing double-byte conversion table for ccsid: " + this.ccsid_, cArray.length);
        }
        char[] cArray2 = new char[65536];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n2;
            int n3;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n++] = cArray[i++];
                    continue;
                }
                long l = (0xFFFF & cArray[i + 1]) + (0xFFFF & n);
                n3 = cArray[i + 2];
                while ((long)n < l) {
                    cArray2[n++] = n3;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n++] = cArray[i++];
                    continue;
                }
                int n4 = 0xFFFF & cArray[i + 2];
                n2 = 0xFFFF & cArray[i + 1];
                for (n3 = n4; n3 < n2 + n4; ++n3) {
                    cArray2[n++] = (char)n3;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n++] = cArray[i++];
                    continue;
                }
                int n5 = 0xFFFF & cArray[++i];
                n2 = cArray[++i];
                n3 = (char)(0xFF00 & n2);
                cArray2[n++] = n2;
                ++i;
                for (int j = 0; j < n5; ++j) {
                    char c = cArray[i + j];
                    cArray2[n++] = (char)(n3 + ((0xFF00 & c) >>> 8));
                    cArray2[n++] = (char)(n3 + (0xFF & c));
                }
                i = i + n5 - 1;
                continue;
            }
            cArray2[n++] = cArray[i];
        }
        return cArray2;
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            try {
                int n4 = ((0xFF & byArray[i * 2 + n]) << 8) + (0xFF & byArray[i * 2 + 1 + n]);
                cArray[n3] = this.toUnicode_[n4];
                if (cArray[n3] == '\ud800') {
                    if (this.toUnicodeSurrogate_ != null) {
                        char[] cArray2 = this.toUnicodeSurrogate_[n4];
                        if (cArray2 != null) {
                            cArray[n3] = cArray2[0];
                            cArray[++n3] = cArray2[1];
                            ++n3;
                            continue;
                        }
                        cArray[n3] = 65533;
                        ++n3;
                        continue;
                    }
                    cArray[n3] = 65533;
                    ++n3;
                    continue;
                }
                ++n3;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw arrayIndexOutOfBoundsException;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i * 2] = (byte)(this.fromUnicode_[cArray[i]] >>> 8);
            byArray[i * 2 + 1] = (byte)(0xFF & this.fromUnicode_[cArray[i]]);
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }
}

