/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import java.io.CharConversionException;

class DBOriginalDataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int REPEATED_LENGTH_ = 54;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int length_ = -1;
    private boolean csRsData_ = false;

    public DBOriginalDataFormat() {
    }

    public DBOriginalDataFormat(int n) {
        this.numberOfFields_ = n;
        this.length_ = 8 + this.numberOfFields_ * 54;
    }

    public void overlay(byte[] byArray, int n) {
        this.rawBytes_ = byArray;
        this.offset_ = n;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToShort(this.rawBytes_, n + 4);
            this.length_ = 8 + this.numberOfFields_ * 54;
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    public int getLength() {
        return this.length_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    public int getRecordSize() {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 6);
    }

    public int getFieldSQLType(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 10 + n * 54);
    }

    public int getFieldLength(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 12 + n * 54);
    }

    public int getFieldScale(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 14 + n * 54);
    }

    public int getFieldPrecision(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + n * 54);
    }

    public int getFieldCCSID(int n) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 18 + n * 54);
    }

    public int getFieldParameterType(int n) {
        return this.rawBytes_[this.offset_ + 20 + n * 54];
    }

    public int getFieldLOBLocator(int n) {
        return -1;
    }

    public int getFieldLOBMaxSize(int n) {
        return -1;
    }

    public int getFieldNameLength(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 28 + n * 54);
    }

    public int getFieldNameCCSID(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 30 + n * 54);
    }

    public String getFieldName(int n, ConvTable convTable) {
        return convTable.byteArrayToString(this.rawBytes_, this.offset_ + 32 + n * 54, this.getFieldNameLength(n));
    }

    public void setConsistencyToken(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_);
    }

    public void setNumberOfFields(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 4);
    }

    public void setRecordSize(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 6);
    }

    public void setFieldDescriptionLength(int n) {
        BinaryConverter.shortToByteArray((short)54, this.rawBytes_, this.offset_ + n * 54 + 8);
    }

    public void setFieldSQLType(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 10);
    }

    public void setFieldLength(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 12);
    }

    public void setFieldScale(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 14);
    }

    public void setFieldPrecision(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 16);
    }

    public void setFieldCCSID(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 18);
    }

    public void setFieldParameterType(int n, int n2) {
        this.rawBytes_[this.offset_ + n * 54 + 20] = (byte)n2;
    }

    public void setFieldNameLength(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 28);
    }

    public void setFieldNameCCSID(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 30);
    }

    public void setFieldName(int n, String string, ConvTable convTable) throws DBDataStreamException {
        try {
            convTable.stringToByteArray(string, this.rawBytes_, this.offset_ + n * 54 + 32);
        }
        catch (CharConversionException charConversionException) {
            throw new DBDataStreamException();
        }
        int n2 = string.length();
        int n3 = this.offset_ + n * 54 + 32;
        for (int i = n2; i < 30; ++i) {
            this.rawBytes_[n3 + i] = 0;
        }
    }

    public int getDateFormat() throws DBDataStreamException {
        return -1;
    }

    public int getTimeFormat() throws DBDataStreamException {
        return -1;
    }

    public int getDateSeparator() throws DBDataStreamException {
        return -1;
    }

    public int getTimeSeparator() throws DBDataStreamException {
        return -1;
    }

    public boolean getCSRSData() {
        return this.csRsData_;
    }

    public void setCSRSData(boolean bl) {
        this.csRsData_ = bl;
    }

    public int getXMLCharType(int n) {
        return -1;
    }

    public int getArrayType(int n) {
        return -1;
    }
}

