/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.JDTrace;
import java.lang.ref.SoftReference;

class DBStoragePool {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final int MAX_POOL_INCREMENT = 4096;
    private static final int STORAGE_POOL_LOCALITY = 256;
    private SoftReference[] pool_ = new SoftReference[16];
    private int lastReturned_;
    private int searches_ = 0;

    DBStoragePool() {
    }

    int getSize() {
        return this.pool_.length;
    }

    final synchronized DBStorage getUnpooledStorage() {
        DBStorage dBStorage = new DBStorage(-1, this);
        dBStorage.canUse();
        return dBStorage;
    }

    final synchronized DBStorage getUnusedStorage() {
        Object object;
        int n;
        int n2 = this.pool_.length;
        int n3 = this.lastReturned_;
        ++this.searches_;
        if (this.searches_ > 4096) {
            n3 = 0;
            this.searches_ = 0;
        }
        for (n = n3; n < n2; ++n) {
            object = this.pool_[n] == null ? null : (DBStorage)this.pool_[n].get();
            if (object == null) {
                object = new DBStorage(n, this);
                ((DBStorage)object).canUse();
                this.pool_[n] = new SoftReference<Object>(object);
                this.lastReturned_ = n + 1;
                return object;
            }
            if (!((DBStorage)object).canUse()) continue;
            this.lastReturned_ = n + 1;
            return object;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Creating new DBStoragePool of size " + n2 * 2);
        }
        n = n2;
        if (n2 > 4096) {
            n = 4096;
        }
        object = new SoftReference[n2 + n];
        for (int i = 0; i < n2; ++i) {
            object[i] = this.pool_[i];
        }
        DBStorage dBStorage = new DBStorage(n2, this);
        dBStorage.canUse();
        object[n2] = new SoftReference<DBStorage>(dBStorage);
        this.pool_ = object;
        this.lastReturned_ = 0;
        return dBStorage;
    }

    public synchronized void returned(int n) {
        if (n < this.lastReturned_ && n >= this.lastReturned_ - 256) {
            this.lastReturned_ = n;
        }
    }
}

