/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.Trace;

class IFSChangeAttrsReq
extends IFSDataStreamReq {
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int CCSID_OFFSET = 26;
    private static final int WORKING_DIR_HANDLE_OFFSET = 28;
    private static final int ATTR_LIST_LEVEL_OFFSET = 32;
    private static final int CREATE_DATE_OFFSET = 34;
    private static final int MODIFY_DATE_OFFSET = 42;
    private static final int ACCESS_DATE_OFFSET = 50;
    private static final int SET_FLAGS_OFFSET = 58;
    private static final int FIXED_ATTRS_OFFSET = 60;
    private static final int FILE_SIZE_OFFSET = 64;
    private static final int LARGE_FILE_SIZE_OFFSET = 68;

    IFSChangeAttrsReq(int n, long l, int n2) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(n2));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(n2));
        this.setReqRepID(11);
        this.set32bit(n, 22);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setData(0L, 34);
        this.setData(0L, 42);
        this.setData(0L, 50);
        this.set16bit(1, 58);
        this.setFileSizeFields(l, n2);
    }

    IFSChangeAttrsReq(int n, long l, long l2, long l3, int n2) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(n2));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(n2));
        this.setReqRepID(11);
        this.set32bit(n, 22);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setDate(l, 34);
        this.setDate(l2, 42);
        this.setDate(l3, 50);
        this.set16bit(0, 58);
    }

    IFSChangeAttrsReq(byte[] byArray, int n, long l, int n2) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(n2) + 6 + byArray.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(n2));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(n, 26);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setData(0L, 34);
        this.setData(0L, 42);
        this.setData(0L, 50);
        this.set16bit(1, 58);
        this.setFileSizeFields(l, n2);
        this.set32bit(byArray.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(n2));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(n2));
        System.arraycopy(byArray, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(n2), byArray.length);
    }

    IFSChangeAttrsReq(byte[] byArray, int n, int n2, boolean bl, int n3) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(n3) + 6 + byArray.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(n3));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(n, 26);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setData(0L, 34);
        this.setData(0L, 42);
        this.setData(0L, 50);
        this.set16bit(2, 58);
        this.set32bit(n2, 60);
        this.setFileSizeFields(0L, n3);
        this.set32bit(byArray.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(n3));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(n3));
        System.arraycopy(byArray, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(n3), byArray.length);
    }

    IFSChangeAttrsReq(byte[] byArray, int n, long l, long l2, long l3, int n2) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(n2) + 6 + byArray.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(n2));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(n, 26);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setDate(l, 34);
        this.setDate(l2, 42);
        this.setDate(l3, 50);
        this.set16bit(0, 58);
        this.set32bit(byArray.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(n2));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(n2));
        System.arraycopy(byArray, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(n2), byArray.length);
    }

    IFSChangeAttrsReq(byte[] byArray, int n, IFSObjAttrs2 iFSObjAttrs2, int n2) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(n2) + 6 + byArray.length + 6 + iFSObjAttrs2.length());
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(n2));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(n, 26);
        this.set32bit(1, 28);
        this.set16bit(5, 32);
        this.set16bit(0, 58);
        this.set32bit(byArray.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(n2));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(n2));
        System.arraycopy(byArray, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(n2), byArray.length);
        int n3 = IFSChangeAttrsReq.getFilenameOffset(n2) + byArray.length;
        this.set32bit(iFSObjAttrs2.getLength() + 6, n3);
        this.set16bit(15, n3 + 4);
        System.arraycopy(iFSObjAttrs2.getData(), 0, this.data_, n3 + 6, iFSObjAttrs2.length());
    }

    private static final int getTemplateLength(int n) {
        return n < 16 ? 48 : 56;
    }

    private static final int getFilenameLLOffset(int n) {
        return n < 16 ? 68 : 76;
    }

    private static final int getFilenameCPOffset(int n) {
        return n < 16 ? 72 : 80;
    }

    private static final int getFilenameOffset(int n) {
        return n < 16 ? 74 : 82;
    }

    private final void setFileSizeFields(long l, int n) {
        if (n < 16) {
            if (l > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified fileSize value (" + l + ") exceeds maximum file length supported by system.");
                }
                l = Integer.MAX_VALUE;
            }
            this.set32bit((int)l, 64);
        } else {
            this.set32bit(0, 64);
            this.set64bit(l, 68);
        }
    }
}

