/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCreateDirHandleRep;
import com.ibm.as400.access.IFSCreateDirHandleReq;
import com.ibm.as400.access.IFSCreateDirReq;
import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.IFSDeleteDirReq;
import com.ibm.as400.access.IFSDeleteFileReq;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSQuerySpaceRep;
import com.ibm.as400.access.IFSQuerySpaceReq;
import com.ibm.as400.access.IFSRenameReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

class IFSFileImplRemote
implements IFSFileImpl {
    private static final boolean DEBUG = false;
    private static final boolean IS_RESTART_NAME = true;
    private static final boolean NO_RESTART_NAME = true;
    private static final boolean SORT_LIST = true;
    private static final int NO_MAX_GET_COUNT = -1;
    private static final int UNINITIALIZED = -1;
    private static final int ACCESS_MODE_EXECUTE = 1;
    private transient IFSListAttrsRep attributesReply_;
    private IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();
    private boolean isSymbolicLink_;
    private boolean determinedIsSymbolicLink_;
    private boolean sortLists_;
    private RemoteCommandImpl rmtCmd_;
    private byte[] qualifiedFileName_;
    private Integer databaseFileAttributes_;
    private static final boolean SPACE_AVAILABLE = true;
    private static final boolean SPACE_TOTAL = false;

    IFSFileImplRemote() {
    }

    public boolean canExecute() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.canAccess(1);
    }

    public boolean canRead() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = this.fd_.checkAccess(1, 8);
        return n == 0;
    }

    public boolean canWrite() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = this.fd_.checkAccess(2, 8);
        return n == 0;
    }

    private boolean canAccess(int n) throws IOException, AS400SecurityException {
        boolean bl;
        block18: {
            if (this.fd_.getSystemVRM() < 327936) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Server is pre-V5R1, so canAccess() is returning false.");
                }
                return false;
            }
            try {
                ProgramParameter[] programParameterArray;
                byte[] byArray;
                if (this.rmtCmd_ == null) {
                    this.setupRemoteCommand();
                }
                if ((byArray = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgAccess", programParameterArray = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(1, BinaryConverter.intToByteArray(n))})) == null) {
                    Trace.log(2, "Call to QlgAccess() returned null.");
                    throw new AS400Exception(this.rmtCmd_.getMessageList());
                }
                int n2 = BinaryConverter.byteArrayToInt(byArray, 0);
                block1 : switch (n2) {
                    case -1: {
                        bl = false;
                        int n3 = BinaryConverter.byteArrayToInt(byArray, 4);
                        switch (n3) {
                            case 3025: {
                                if (Trace.traceOn_) {
                                    Trace.log(1, "Received errno " + n3 + " from QlgAccess() for file " + this.fd_.path_ + ". Assuming that the file does not exist.");
                                    break block1;
                                }
                                break block18;
                            }
                            case 3401: {
                                if (Trace.traceOn_) {
                                    Trace.log(1, "Received errno " + n3 + " from QlgAccess() for file " + this.fd_.path_ + ". Assuming that the user does not have the specified access.");
                                    break block1;
                                }
                                break block18;
                            }
                            default: {
                                Trace.log(2, "Received errno " + n3 + " from QlgAccess() for file " + this.fd_.path_);
                                throw new ExtendedIOException(this.fd_.path_, 25, n3);
                            }
                        }
                    }
                    case 0: {
                        bl = true;
                        break;
                    }
                    default: {
                        Trace.log(2, "Received unexpected return value " + n2 + " from QlgAccess() for file " + this.fd_.path_);
                        throw new InternalErrorException(9, "QlgAccess()", n2);
                    }
                }
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw aS400SecurityException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                Trace.log(2, "Error while determining accessibility of file.", (Throwable)exception);
                throw new ExtendedIOException(this.fd_.path_, 25);
            }
        }
        return bl;
    }

    public boolean setAccess(int n, boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        if (this.fd_.getSystemVRM() < 327936) {
            if (Trace.traceOn_) {
                Trace.log(4, "Server is pre-V5R1, so setAccess() is not supported.");
            }
            return false;
        }
        try {
            if (this.rmtCmd_ == null) {
                this.setupRemoteCommand();
            }
            int n2 = this.getAccess();
            int n3 = n << 6;
            if (!bl2) {
                n3 = n3 | n << 3 | n;
            }
            int n4 = bl ? n2 | n3 : n2 & ~n3;
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(1, BinaryConverter.intToByteArray(n4 &= 0xFFF))};
            byte[] byArray = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgChmod", programParameterArray);
            if (byArray == null) {
                Trace.log(2, "Call to QlgChmod() returned null.");
                throw new AS400Exception(this.rmtCmd_.getMessageList());
            }
            int n5 = BinaryConverter.byteArrayToInt(byArray, 0);
            switch (n5) {
                case -1: {
                    int n6 = BinaryConverter.byteArrayToInt(byArray, 4);
                    Trace.log(2, "Received errno " + n6 + " from QlgChmod() for file " + this.fd_.path_);
                    throw new ExtendedIOException(this.fd_.path_, 25, n6);
                }
                case 0: {
                    break;
                }
                default: {
                    Trace.log(2, "Received unexpected return value " + n5 + " from QlgChmod() for file " + this.fd_.path_);
                    throw new InternalErrorException(9, "QlgChmod()", n5);
                }
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw aS400SecurityException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Trace.log(2, "Error while determining accessibility of file.", (Throwable)exception);
            throw new ExtendedIOException(this.fd_.path_, 25);
        }
        return true;
    }

    private int getAccess() throws IOException, AS400SecurityException, ObjectDoesNotExistException {
        int n = 0;
        try {
            if (this.rmtCmd_ == null) {
                this.setupRemoteCommand();
            }
            int n2 = 128;
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, n2)};
            byte[] byArray = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgStat", programParameterArray);
            if (byArray == null) {
                Trace.log(2, "Call to QlgStat() returned null.");
                throw new AS400Exception(this.rmtCmd_.getMessageList());
            }
            int n3 = BinaryConverter.byteArrayToInt(byArray, 0);
            switch (n3) {
                case -1: {
                    int n4 = BinaryConverter.byteArrayToInt(byArray, 4);
                    switch (n4) {
                        case 3025: {
                            Trace.log(2, "Received errno " + n4 + " from QlgStat() for file " + this.fd_.path_ + ". Assuming that the file does not exist.");
                            throw new ObjectDoesNotExistException(this.fd_.path_, 2);
                        }
                        case 3401: {
                            Trace.log(2, "Received errno " + n4 + " from QlgStat() for file " + this.fd_.path_ + ". Assuming that the user does not have permission to access the file.");
                            throw new AS400SecurityException(this.fd_.path_, 1);
                        }
                    }
                    Trace.log(2, "Received errno " + n4 + " from QlgStat() for file " + this.fd_.path_);
                    throw new ExtendedIOException(this.fd_.path_, 25, n4);
                }
                case 0: {
                    n = this.parseStatInfo(programParameterArray[1].getOutputData());
                    break;
                }
                default: {
                    Trace.log(2, "Received unexpected return value " + n3 + " from QlgStat() for file " + this.fd_.path_);
                    throw new InternalErrorException(9, "QlgStat()", n3);
                }
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw aS400SecurityException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Trace.log(2, "Error while determining accessibility of file.", (Throwable)exception);
            throw new ExtendedIOException(this.fd_.path_, 25);
        }
        return n;
    }

    public void clearCachedAttributes() {
        this.attributesReply_ = null;
        this.databaseFileAttributes_ = null;
    }

    public boolean copyTo(String string, boolean bl) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        this.fd_.connect();
        if (Trace.traceOn_ && !bl && this.fd_.getSystemVRM() < 328448) {
            Trace.log(4, "Server is V5R2 or lower, so the 'Do not replace' argument will be ignored.");
        }
        if (this.isDirectory() == 0 && this.exists(string) == 0) {
            throw new ObjectAlreadyExistsException(string, 1);
        }
        return this.fd_.copyTo(string, bl);
    }

    public long created() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getCreationDate();
        }
        return l;
    }

    public int createNewFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(2, 4);
    }

    public int delete() throws IOException, AS400SecurityException {
        IFSDataStreamReq iFSDataStreamReq;
        block13: {
            this.fd_.connect();
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            iFSDataStreamReq = new IFSDeleteFileReq(byArray, this.fd_.preferredServerCCSID_);
            try {
                if (this.isDirectory() == 0) {
                    iFSDataStreamReq = new IFSDeleteDirReq(byArray, this.fd_.preferredServerCCSID_);
                }
            }
            catch (Exception exception) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unable to determine if file or directory.\n" + exception.toString());
                }
                if (this.fd_.server_ != null) break block13;
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                IOException iOException = new IOException(exception.toString());
                try {
                    iOException.initCause(exception);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw iOException;
            }
        }
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSDataStreamReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 0;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0 && Trace.traceOn_) {
                Trace.log(2, "IFSReturnCodeRep return code", n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()));
        }
        this.attributesReply_ = null;
        return n;
    }

    private boolean determineIsDirectory(IFSListAttrsRep iFSListAttrsRep) {
        boolean bl = false;
        switch (iFSListAttrsRep.getObjectType()) {
            case 1: 
            case 2: {
                bl = (iFSListAttrsRep.getFixedAttributes() & 0x10) != 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean determineIsFile(IFSListAttrsRep iFSListAttrsRep) {
        boolean bl = false;
        switch (iFSListAttrsRep.getObjectType()) {
            case 1: 
            case 2: {
                bl = (iFSListAttrsRep.getFixedAttributes() & 0x10) == 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public int exists() throws IOException, AS400SecurityException {
        return this.exists(this.fd_.path_);
    }

    private int exists(String string) throws IOException, AS400SecurityException {
        int n = 0;
        this.fd_.connect();
        n = 2;
        try {
            IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(string);
            if (iFSListAttrsRep != null) {
                n = 0;
                this.attributesReply_ = iFSListAttrsRep;
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            n = 5;
        }
        return n;
    }

    String getAbsolutePath() {
        return this.fd_.path_;
    }

    private IFSListAttrsRep getAttributeSetFromServer(String string) throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = null;
        Vector vector = this.listAttributes(string, -1, null, true, false);
        if (vector != null && vector.size() == 1) {
            iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
        }
        return iFSListAttrsRep;
    }

    public int getCCSID() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.getCCSID();
    }

    public long getAvailableSpace(boolean bl) throws IOException, AS400SecurityException {
        long l = this.getAmountOfSpace(bl, true);
        if (bl) {
            long l2 = this.getAmountOfSpace(false, true);
            l = Math.min(l, l2);
        }
        return l;
    }

    public long getTotalSpace(boolean bl) throws IOException, AS400SecurityException {
        return this.getAmountOfSpace(bl, false);
    }

    private long getAmountOfSpace(boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        Object object;
        int n;
        this.fd_.connect();
        long l = 0L;
        ClientAccessDataStream clientAccessDataStream = null;
        int n2 = 0;
        if (bl) {
            n = 0;
        } else {
            object = this.fd_.path_;
            if (this.isDirectory() != 0) {
                object = IFSFile.getParent(this.fd_.path_);
            }
            byte[] byArray = this.fd_.getConverter().stringToByteArray((String)object);
            try {
                IFSCreateDirHandleReq iFSCreateDirHandleReq = new IFSCreateDirHandleReq(byArray, this.fd_.preferredServerCCSID_);
                clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSCreateDirHandleReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                throw new InterruptedIOException(interruptedException.getMessage());
            }
            n2 = 0;
            if (clientAccessDataStream instanceof IFSCreateDirHandleRep) {
                n = ((IFSCreateDirHandleRep)clientAccessDataStream).getHandle();
            } else {
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n2 != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", n2);
                    }
                    throw new ExtendedIOException(this.fd_.path_, n2);
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
        }
        clientAccessDataStream = null;
        try {
            object = new IFSQuerySpaceReq(n);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive((DataStream)object);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        n2 = 0;
        if (clientAccessDataStream instanceof IFSQuerySpaceRep) {
            l = bl2 ? ((IFSQuerySpaceRep)clientAccessDataStream).getSpaceAvailable() : ((IFSQuerySpaceRep)clientAccessDataStream).getTotalSpace();
        } else {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n2 != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", n2);
                }
                throw new ExtendedIOException(this.fd_.path_, n2);
            }
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()));
        }
        return l;
    }

    public String getOwnerName() throws IOException, AS400SecurityException {
        String string = null;
        this.fd_.connect();
        try {
            IFSListAttrsRep iFSListAttrsRep = this.fd_.listObjAttrs1(2048, 0);
            if (iFSListAttrsRep != null) {
                string = iFSListAttrsRep.getOwnerName(this.fd_.system_.getCcsid());
            } else {
                if (Trace.traceOn_) {
                    Trace.log(4, "getOwnerName: IFSReturnCodeRep return code", this.fd_.errorRC_);
                }
                if (this.fd_.errorRC_ == 2 || this.fd_.errorRC_ == 3) {
                    throw new ExtendedIOException(this.fd_.path_, 3);
                }
            }
        }
        catch (ExtendedIOException extendedIOException) {
            if (extendedIOException.getReturnCode() == 4) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unable to determine owner of directory.", (Throwable)extendedIOException);
                }
            }
            throw extendedIOException;
        }
        return string == null ? "" : string;
    }

    public long getOwnerUID() throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSListAttrsRep iFSListAttrsRep = this.fd_.listObjAttrs2();
        if (iFSListAttrsRep != null) {
            return iFSListAttrsRep.getOwnerUID();
        }
        return -1L;
    }

    public String getPathPointedTo() throws IOException, AS400SecurityException {
        this.fd_.connect();
        String string = null;
        try {
            boolean bl;
            if (this.rmtCmd_ == null) {
                this.setupRemoteCommand();
            }
            int n = 1024;
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, n), new ProgramParameter(1, BinaryConverter.intToByteArray(n))};
            block8: do {
                int n2;
                bl = false;
                byte[] byArray = this.rmtCmd_.runServiceProgram("QSYS", "QP0LLIB1", "QlgReadlink", programParameterArray);
                if (byArray == null) {
                    Trace.log(2, "Call to QlgReadlink() returned null.");
                    throw new AS400Exception(this.rmtCmd_.getMessageList());
                }
                int n3 = BinaryConverter.byteArrayToInt(byArray, 0);
                if (n3 == -1) {
                    n2 = BinaryConverter.byteArrayToInt(byArray, 4);
                    switch (n2) {
                        case 3021: {
                            if (!Trace.traceOn_) continue block8;
                            Trace.log(1, "Received errno " + n2 + " from QlgReadlink() for file " + this.fd_.path_ + ". Assuming that the file is not a symbolic link.");
                            continue block8;
                        }
                        case 3025: {
                            if (!Trace.traceOn_) continue block8;
                            Trace.log(1, "Received errno " + n2 + " from QlgReadlink() for file " + this.fd_.path_ + ". Assuming that the file does not exist.");
                            continue block8;
                        }
                        default: {
                            Trace.log(2, "Received errno " + n2 + " from QlgReadlink() for file " + this.fd_.path_);
                            throw new ExtendedIOException(this.fd_.path_, 25, n2);
                        }
                    }
                }
                if (n3 + 32 > n) {
                    bl = true;
                    n2 = n3 + 32;
                    if (Trace.traceOn_) {
                        Trace.log(1, "QlgReadlink() buffer too small. Buffer size provided: " + n + ". Buffer size needed: " + n2 + ". Calling QlgReadLink() with larger buffer.");
                    }
                    n = n2;
                    programParameterArray[1].setOutputDataLength(n);
                    programParameterArray[2].setInputData(BinaryConverter.intToByteArray(n));
                    continue;
                }
                string = this.parsePathName(programParameterArray[1].getOutputData());
            } while (bl);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw aS400SecurityException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Trace.log(2, "Error while resolving symbolic link.", (Throwable)exception);
            throw new ExtendedIOException(this.fd_.path_, 25);
        }
        return string;
    }

    private byte[] createPathName() throws IOException {
        ConverterImplRemote converterImplRemote = new ConverterImplRemote();
        converterImplRemote.setCcsid(1200, this.fd_.system_);
        int n = this.fd_.path_.length();
        byte[] byArray = new byte[32 + n * 2];
        BinaryConverter.intToByteArray(1200, byArray, 0);
        BinaryConverter.intToByteArray(2, byArray, 12);
        BinaryConverter.intToByteArray(n * 2, byArray, 16);
        converterImplRemote.stringToByteArray("/", byArray, 20, 2);
        converterImplRemote.stringToByteArray(this.fd_.path_, byArray, 32);
        return byArray;
    }

    private String parsePathName(byte[] byArray) throws IOException {
        ConverterImplRemote converterImplRemote = new ConverterImplRemote();
        converterImplRemote.setCcsid(1200, this.fd_.system_);
        int n = 0;
        int n2 = BinaryConverter.byteArrayToInt(byArray, n += 16);
        String string = converterImplRemote.byteArrayToString(byArray, n += 16, n2);
        return string;
    }

    private int parseStatInfo(byte[] byArray) throws IOException {
        ConverterImplRemote converterImplRemote = new ConverterImplRemote();
        converterImplRemote.setCcsid(37, this.fd_.system_);
        int n = BinaryConverter.byteArrayToInt(byArray, 0);
        return n;
    }

    public String getSubtype() throws IOException, AS400SecurityException {
        byte[][] byArrayArray;
        int n;
        Object object;
        String string = "";
        this.fd_.connect();
        byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
        boolean bl = this.fd_.getSystemVRM() >= 393472 && this.fd_.path_.indexOf("/QSYS.LIB") != -1;
        byte[] byArray2 = this.fd_.converter_.stringToByteArray(".TYPE");
        if (bl) {
            object = this.fd_.converter_.stringToByteArray(".CODEPAGE");
            n = byArray2.length + ((byte[])object).length;
            byArrayArray = new byte[][]{byArray2, object};
        } else {
            n = byArray2.length;
            byArrayArray = new byte[][]{byArray2};
        }
        object = new IFSListAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0, -1, null, false, byArrayArray, n, false, this.fd_.patternMatching_);
        Vector vector = this.fd_.listAttributes((IFSListAttrsReq)object);
        if (vector == null) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received null from listAttributes(req).");
            }
        } else if (vector.size() == 0) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received no replies from listAttributes(req).");
            }
        } else {
            IFSListAttrsRep iFSListAttrsRep;
            Hashtable hashtable;
            byte[] byArray3;
            if (vector.size() > 1 && Trace.traceOn_) {
                Trace.log(4, "Received multiple replies from listAttributes(req) (" + vector.size() + ")");
            }
            if ((byArray3 = (byte[])(hashtable = (iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0)).getExtendedAttributeValues()).get(".TYPE")) != null) {
                int n2;
                if (!bl) {
                    n2 = 37;
                } else {
                    byte[] byArray4 = (byte[])hashtable.get(".CODEPAGE");
                    byte[] byArray5 = new byte[]{byArray4[1], byArray4[0]};
                    n2 = BinaryConverter.byteArrayToUnsignedShort(byArray5, 0);
                    if (n2 == 1400) {
                        n2 = 1200;
                    }
                }
                try {
                    string = new CharConverter(n2).byteArrayToString(byArray3, 0).trim();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.log(2, "Unrecognized codepage returned: " + n2, (Throwable)unsupportedEncodingException);
                    string = "??";
                }
            }
        }
        return string;
    }

    public boolean isSourcePhysicalFile() throws IOException, AS400SecurityException, AS400Exception {
        int n = this.retrieveDatabaseFileAttributes();
        return (n & 0x800) != 0;
    }

    private int retrieveDatabaseFileAttributes() throws IOException, AS400SecurityException, AS400Exception {
        if (this.databaseFileAttributes_ == null) {
            try {
                int n = 400;
                ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n), new ProgramParameter(BinaryConverter.intToByteArray(n)), new ProgramParameter(20), new ProgramParameter(new byte[]{-58, -55, -45, -60, -16, -15, -16, -16}), new ProgramParameter(this.composeQualifiedNameBytes()), new ProgramParameter(new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64}), new ProgramParameter(new byte[]{-16}), new ProgramParameter(new byte[]{92, -45, -61, -45, 64, 64, 64, 64, 64, 64}), new ProgramParameter(new byte[]{92, -55, -43, -29, 64, 64, 64, 64, 64, 64}), new ErrorCodeParameter()};
                if (this.rmtCmd_ == null) {
                    this.setupRemoteCommand();
                }
                if (!this.rmtCmd_.runProgram("QSYS", "QDBRTVFD", programParameterArray)) {
                    throw new AS400Exception(this.rmtCmd_.getMessageList());
                }
                byte[] byArray = programParameterArray[0].getOutputData();
                int n2 = BinaryConverter.byteArrayToInt(byArray, 0);
                if (n2 < 10) {
                    Trace.log(2, "Insufficient output bytes returned from QDBRTVFD: " + n2);
                    throw new InternalErrorException(this.fd_.path_, 6);
                }
                this.databaseFileAttributes_ = new Integer(BinaryConverter.byteArrayToUnsignedShort(byArray, 8));
            }
            catch (AS400Exception aS400Exception) {
                throw aS400Exception;
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw aS400SecurityException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                Trace.log(2, "Error while retrieving database file attributes.", (Throwable)exception);
                throw new ExtendedIOException(this.fd_.path_, 25);
            }
        }
        return this.databaseFileAttributes_;
    }

    private synchronized byte[] composeQualifiedNameBytes() throws IOException {
        if (this.qualifiedFileName_ == null) {
            CharConverter charConverter = new CharConverter(37);
            this.qualifiedFileName_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.fd_.path_);
            String string = qSYSObjectPathName.getLibraryName();
            String string2 = qSYSObjectPathName.getObjectName();
            charConverter.stringToByteArray(string2, this.qualifiedFileName_, 0);
            charConverter.stringToByteArray(string, this.qualifiedFileName_, 10);
        }
        return this.qualifiedFileName_;
    }

    public int isDirectory() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = 2;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null && this.determineIsDirectory(this.attributesReply_)) {
            n = 0;
        }
        return n;
    }

    public int isFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = 2;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null && this.determineIsFile(this.attributesReply_)) {
            n = 0;
        }
        return n;
    }

    public boolean isHidden() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            bl = (this.attributesReply_.getFixedAttributes() & 2) != 0;
        }
        return bl;
    }

    public boolean isReadOnly() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            bl = (this.attributesReply_.getFixedAttributes() & 1) != 0;
        }
        return bl;
    }

    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        this.fd_.connect();
        if (this.fd_.getSystemVRM() < 328448) {
            if (Trace.traceOn_) {
                Trace.log(4, "Server is V5R2 or lower, so isSymbolicLink() will always report false.");
            }
            return false;
        }
        if (!this.determinedIsSymbolicLink_) {
            int n = this.fd_.path_.length();
            if (n <= 1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Path length is less than 2, so assuming not a symbolic link: " + this.fd_.path_);
                }
                this.isSymbolicLink_ = false;
                this.determinedIsSymbolicLink_ = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.fd_.path_);
                stringBuffer.setCharAt(n - 1, '*');
                String string = stringBuffer.toString();
                String string2 = string.substring(0, 1 + string.lastIndexOf(47));
                byte[] byArray = this.fd_.converter_.stringToByteArray(string);
                IFSCachedAttributes[] iFSCachedAttributesArray = this.listDirectoryDetails(string, string2, -1, byArray, true, false);
                IFSCachedAttributes iFSCachedAttributes = null;
                String string3 = this.fd_.path_.substring(1 + this.fd_.path_.lastIndexOf(47));
                for (int i = 0; iFSCachedAttributes == null && i < iFSCachedAttributesArray.length; ++i) {
                    if (!iFSCachedAttributesArray[i].name_.equals(string3)) continue;
                    iFSCachedAttributes = iFSCachedAttributesArray[i];
                }
                if (iFSCachedAttributes != null) {
                    this.isSymbolicLink_ = iFSCachedAttributes.isSymbolicLink_;
                    this.determinedIsSymbolicLink_ = true;
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Received zero matches from listDirectoryDetails() against parent of " + string);
                    }
                    this.isSymbolicLink_ = false;
                    this.determinedIsSymbolicLink_ = true;
                }
            }
        }
        return this.isSymbolicLink_;
    }

    public long lastAccessed() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getAccessDate();
        }
        return l;
    }

    public long lastModified() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getModificationDate();
        }
        return l;
    }

    public long length() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        if (this.fd_.getSystemVRM() >> 8 != 1282) {
            IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
            if (iFSListAttrsRep != null) {
                this.attributesReply_ = iFSListAttrsRep;
                l = iFSListAttrsRep.getSize(this.fd_.serverDatastreamLevel_);
            }
        } else {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0, -1, null, true, null, 0, true, this.fd_.patternMatching_);
            Vector vector = this.fd_.listAttributes(iFSListAttrsReq);
            if (vector == null) {
                if (this.fd_.errorRC_ != 0) {
                    throw new ExtendedIOException(this.fd_.path_, this.fd_.errorRC_);
                }
                throw new InternalErrorException(6);
            }
            if (vector.size() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received no replies from listAttributes(req).");
                }
            } else {
                if (vector.size() > 1 && Trace.traceOn_) {
                    Trace.log(4, "Received multiple replies from listAttributes(req) (" + vector.size() + ")");
                }
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
                l = iFSListAttrsRep.getSize8Bytes();
            }
        }
        return l;
    }

    private Vector listAttributes(String string, int n, byte[] byArray, boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        byte[] byArray2 = this.fd_.converter_.stringToByteArray(string);
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray2, this.fd_.preferredServerCCSID_, 0, n, byArray, bl, null, 0, false, this.fd_.patternMatching_);
        if (bl2) {
            iFSListAttrsReq.setSorted(true);
        }
        return this.fd_.listAttributes(iFSListAttrsReq);
    }

    public String[] listDirectoryContents(String string) throws IOException, AS400SecurityException {
        this.fd_.connect();
        Vector vector = this.listAttributes(string, -1, null, true, this.sortLists_);
        String[] stringArray = null;
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(i);
                String string2 = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
                if (string2.equals(".") || string2.equals("..")) continue;
                stringArray[n++] = string2;
            }
            if (n == 0) {
                stringArray = new String[]{};
            } else if (stringArray.length != n) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    private IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, byte[] byArray, boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSCachedAttributes[] iFSCachedAttributesArray = null;
        try {
            Vector vector = this.listAttributes(string, n, byArray, bl, bl2);
            int n2 = 0;
            if (vector != null) {
                iFSCachedAttributesArray = new IFSCachedAttributes[vector.size()];
                int n3 = this.fd_.serverDatastreamLevel_;
                for (int i = 0; i < vector.size(); ++i) {
                    IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(i);
                    String string3 = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
                    if (string3.equals(".") || string3.equals("..")) continue;
                    boolean bl3 = this.determineIsDirectory(iFSListAttrsRep);
                    boolean bl4 = this.determineIsFile(iFSListAttrsRep);
                    IFSCachedAttributes iFSCachedAttributes = new IFSCachedAttributes(iFSListAttrsRep.getAccessDate(), iFSListAttrsRep.getCreationDate(), iFSListAttrsRep.getFixedAttributes(), iFSListAttrsRep.getModificationDate(), iFSListAttrsRep.getObjectType(), iFSListAttrsRep.getSize(n3), string3, string2, bl3, bl4, iFSListAttrsRep.getRestartID(), iFSListAttrsRep.isSymbolicLink(n3));
                    iFSCachedAttributesArray[n2++] = iFSCachedAttributes;
                }
            }
            if (n2 == 0) {
                iFSCachedAttributesArray = new IFSCachedAttributes[]{};
            } else if (iFSCachedAttributesArray.length != n2) {
                IFSCachedAttributes[] iFSCachedAttributesArray2 = new IFSCachedAttributes[n2];
                System.arraycopy(iFSCachedAttributesArray, 0, iFSCachedAttributesArray2, 0, n2);
                iFSCachedAttributesArray = iFSCachedAttributesArray2;
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            iFSCachedAttributesArray = null;
            throw aS400SecurityException;
        }
        return iFSCachedAttributesArray;
    }

    public IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, String string3) throws IOException, AS400SecurityException {
        byte[] byArray = this.fd_.converter_.stringToByteArray(string3);
        return this.listDirectoryDetails(string, string2, n, byArray, true, this.sortLists_);
    }

    public IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, byte[] byArray, boolean bl) throws IOException, AS400SecurityException {
        boolean bl2 = bl ? this.sortLists_ : false;
        return this.listDirectoryDetails(string, string2, n, byArray, false, bl2);
    }

    public int mkdir(String string) throws IOException, AS400SecurityException {
        int n;
        block5: {
            this.fd_.connect();
            n = 2;
            try {
                byte[] byArray = this.fd_.converter_.stringToByteArray(string);
                IFSCreateDirReq iFSCreateDirReq = new IFSCreateDirReq(byArray, this.fd_.preferredServerCCSID_);
                ClientAccessDataStream clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSCreateDirReq);
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n == 5 || n == 13) {
                        throw new AS400SecurityException(string, 1);
                    }
                    break block5;
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
        return n;
    }

    public int mkdirs() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String string = this.fd_.path_;
        int n = 2;
        n = this.exists(string);
        if (n != 0) {
            do {
                vector.addElement(string);
            } while ((string = IFSFile.getParent(string)) != null && this.exists(string) != 0);
        } else {
            n = 4;
        }
        for (int i = vector.size(); i > 0 && (n = this.mkdir(string = (String)vector.elementAt(i - 1))) == 0; --i) {
        }
        return n;
    }

    public int renameTo(IFSFileImpl iFSFileImpl) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        ClientAccessDataStream clientAccessDataStream = null;
        IFSFileImplRemote iFSFileImplRemote = (IFSFileImplRemote)iFSFileImpl;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            byte[] byArray2 = this.fd_.converter_.stringToByteArray(iFSFileImplRemote.getAbsolutePath());
            IFSRenameReq iFSRenameReq = new IFSRenameReq(byArray, byArray2, this.fd_.preferredServerCCSID_, false);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSRenameReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 2;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error renaming file: IFSReturnCodeRep return code", n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()));
        }
        if (bl) {
            this.fd_.path_ = iFSFileImplRemote.getAbsolutePath();
            this.attributesReply_ = null;
        }
        return n;
    }

    public boolean setCCSID(int n) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSListAttrsRep iFSListAttrsRep = this.fd_.listObjAttrs2();
        if (iFSListAttrsRep == null) {
            if (this.fd_.errorRC_ != 0) {
                throw new ExtendedIOException(this.fd_.path_, this.fd_.errorRC_);
            }
            throw new InternalErrorException(6);
        }
        boolean bl = false;
        IFSObjAttrs2 iFSObjAttrs2 = iFSListAttrsRep.getObjAttrs2();
        if (Trace.traceOn_) {
            Trace.log(1, "Length of returned OA2* structure (should be 144 or 160): " + iFSObjAttrs2.length());
        }
        iFSObjAttrs2.setCCSID(n, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, iFSObjAttrs2, this.fd_.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n2 == 0) {
                bl = true;
                this.fd_.setCCSID(n);
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file data CCSID: IFSReturnCodeRep return code", n2);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()));
        }
        return bl;
    }

    public boolean setFixedAttributes(int n) throws IOException, AS400SecurityException {
        this.fd_.connect();
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n, true, this.fd_.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        boolean bl = false;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n2 == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file attributes: IFSReturnCodeRep return code", n2);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()));
        }
        this.attributesReply_ = null;
        return bl;
    }

    public boolean setHidden(boolean bl) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl2 = false;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            boolean bl3;
            int n = iFSListAttrsRep.getFixedAttributes();
            boolean bl4 = bl3 = (n & 2) != 0;
            if (bl3 != bl) {
                int n2 = bl ? n + 2 : n & 0x7FFFFFFD;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n2, true, this.fd_.serverDatastreamLevel_);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) {
                        bl2 = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting hidden attribute: IFSReturnCodeRep return code", n3);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLastModified(long l) throws IOException, AS400SecurityException {
        int n = -1;
        boolean bl = false;
        try {
            this.fd_.connect();
            if (l == -1L) {
                n = this.fd_.createFileHandle(2, 8);
                if (n == -1) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.fd_.setOpen(true, n);
                byte[] byArray = new byte[1];
                boolean bl3 = false;
                if (l == -1L) {
                    boolean bl4 = bl3 = this.length() == 0L;
                }
                if (bl3) {
                    this.fd_.writeBytes(byArray, 0, 1, true);
                    bl = this.fd_.setLength(0L);
                } else if (1 == this.fd_.read(byArray, 0, 1)) {
                    this.fd_.setFileOffset(0L);
                    this.fd_.writeBytes(byArray, 0, 1, true);
                    bl = true;
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Unable to read first byte of file.");
                    }
                    bl = false;
                }
            } else {
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0L, l, 0L, this.fd_.serverDatastreamLevel_);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n2 == 0) {
                        bl = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting last-modified date: IFSReturnCodeRep return code", n2);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
            }
            this.attributesReply_ = null;
        }
        finally {
            if (n != -1) {
                this.fd_.close(n);
            }
        }
        return bl;
    }

    public boolean setLength(int n) throws IOException, AS400SecurityException {
        this.fd_.connect();
        this.attributesReply_ = null;
        return this.fd_.setLength(n);
    }

    public void setPath(String string) {
        if (this.fd_.server_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = string.length() == 0 || string.charAt(0) != '/' ? "/" + string : string;
        this.fd_.path_ = string2;
    }

    private static final void setPassByReference(ProgramParameter programParameter) {
        try {
            programParameter.setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
        }
    }

    public void setPatternMatching(int n) {
        this.fd_.patternMatching_ = n;
    }

    public boolean setReadOnly(boolean bl) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl2 = false;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            boolean bl3;
            int n = iFSListAttrsRep.getFixedAttributes();
            boolean bl4 = bl3 = (n & 1) != 0;
            if (bl3 != bl) {
                int n2 = bl ? n + 1 : n & 0x7FFFFFFE;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n2, true, this.fd_.serverDatastreamLevel_);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) {
                        bl2 = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting read-only attribute: IFSReturnCodeRep return code", n3);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    public void setSorted(boolean bl) {
        this.sortLists_ = bl;
    }

    public void setSystem(AS400Impl aS400Impl) {
        this.fd_.system_ = (AS400ImplRemote)aS400Impl;
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.rmtCmd_ == null) {
            if (this.fd_.system_.canUseNativeOptimizations()) {
                try {
                    this.rmtCmd_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                }
                catch (Throwable throwable) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", throwable);
                }
            }
            if (this.rmtCmd_ == null) {
                this.rmtCmd_ = new RemoteCommandImplRemote();
            }
            this.rmtCmd_.setSystem(this.fd_.system_);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSCreateDirHandleRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSQuerySpaceRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

