/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AS400TreeModel;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PopupMenuAdapter;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.TreeSelectionEventSupport;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VEmptyNode;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellEditor;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class AS400TreePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static VNode dummyRoot_ = new VEmptyNode();
    boolean allowActions_ = true;
    boolean confirm_ = true;
    AS400TreeModel model_ = new AS400TreeModel(dummyRoot_);
    JTree tree_ = new JTree(this.model_);
    private transient VActionContext actionContext_;
    private transient PopupMenuAdapter popupMenuAdapter_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient TreeSelectionEventSupport treeSelectionEventSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public AS400TreePane() {
        this.tree_.setCellEditor(new VObjectCellEditor());
        this.tree_.setCellRenderer(new VObjectCellRenderer());
        this.tree_.setEditable(true);
        this.tree_.setRootVisible(true);
        this.tree_.setShowsRootHandles(true);
        this.tree_.getSelectionModel().setSelectionMode(1);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.tree_));
        this.initializeTransient();
    }

    public AS400TreePane(VNode vNode) {
        this();
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        try {
            this.model_.setRoot(vNode);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.expand(vNode);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treeSelectionEventSupport_.addTreeSelectionListener(treeSelectionListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void collapse(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        int n = this.findRow(vNode);
        if (n >= 0) {
            this.tree_.collapseRow(n);
        }
    }

    public void expand(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        int n = this.findRow(vNode);
        if (n >= 0) {
            this.tree_.expandRow(n);
        }
    }

    private int findRow(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        TreePath treePath = this.getPath(vNode);
        if (treePath != null) {
            return this.tree_.getRowForPath(treePath);
        }
        return -1;
    }

    public VActionContext getActionContext() {
        return this.actionContext_;
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public boolean getConfirm() {
        return this.confirm_;
    }

    public TreeModel getModel() {
        return this.model_;
    }

    public TreePath getPath(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        return this.model_.getPath(vNode);
    }

    public VNode getRoot() {
        VNode vNode = (VNode)this.model_.getRoot();
        if (vNode == dummyRoot_) {
            return null;
        }
        return vNode;
    }

    public VNode getSelectedObject() {
        VNode vNode = null;
        TreePath treePath = this.tree_.getSelectionPath();
        if (treePath != null) {
            vNode = (VNode)treePath.getLastPathComponent();
        }
        return vNode;
    }

    public VNode[] getSelectedObjects() {
        VNode[] vNodeArray = null;
        TreePath[] treePathArray = this.tree_.getSelectionPaths();
        if (treePathArray != null) {
            vNodeArray = new VNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                vNodeArray[i] = (VNode)treePathArray[i].getLastPathComponent();
            }
        } else {
            vNodeArray = new VNode[]{};
        }
        return vNodeArray;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree_.getSelectionModel();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.treeSelectionEventSupport_ = new TreeSelectionEventSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.model_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.tree_.addTreeSelectionListener(this.treeSelectionEventSupport_);
        this.actionContext_ = new VActionContext_();
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.tree_));
        VPane_ vPane_ = new VPane_();
        this.popupMenuAdapter_ = new PopupMenuAdapter(vPane_, this.actionContext_);
        if (this.allowActions_) {
            this.tree_.addMouseListener(this.popupMenuAdapter_);
        }
    }

    public boolean isCollapsed(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        int n = this.findRow(vNode);
        if (n >= 0) {
            return this.tree_.isCollapsed(n);
        }
        return false;
    }

    public boolean isExpanded(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        int n = this.findRow(vNode);
        if (n >= 0) {
            return this.tree_.isExpanded(n);
        }
        return false;
    }

    public boolean isSelected(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        int n = this.findRow(vNode);
        if (n > 0) {
            return this.tree_.isRowSelected(n);
        }
        return false;
    }

    public boolean isVisible(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        TreePath treePath = this.getPath(vNode);
        if (treePath != null) {
            if (this.tree_.getPathBounds(this.model_.getPath(vNode)) == null) {
                return false;
            }
            return this.tree_.isVisible(treePath);
        }
        return false;
    }

    public void load() {
        this.model_.load();
        this.expand((VNode)this.model_.getRoot());
    }

    public void makeVisible(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("object");
        }
        TreePath treePath = this.getPath(vNode);
        if (treePath != null) {
            this.tree_.makeVisible(treePath);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treeSelectionEventSupport_.removeTreeSelectionListener(treeSelectionListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setAllowActions(boolean bl) {
        if (this.allowActions_ != bl) {
            this.allowActions_ = bl;
            if (this.allowActions_) {
                this.tree_.addMouseListener(this.popupMenuAdapter_);
            } else {
                this.tree_.removeMouseListener(this.popupMenuAdapter_);
            }
        }
    }

    public void setConfirm(boolean bl) {
        this.confirm_ = bl;
    }

    public void setRoot(VNode vNode) throws PropertyVetoException {
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        this.tree_.clearSelection();
        this.model_.setRoot(vNode);
        this.expand(vNode);
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        TreeSelectionModel treeSelectionModel2 = this.tree_.getSelectionModel();
        if (treeSelectionModel2 != null) {
            treeSelectionModel2.removeTreeSelectionListener(this.treeSelectionEventSupport_);
        }
        this.tree_.setSelectionModel(treeSelectionModel);
        if (treeSelectionModel != null) {
            treeSelectionModel.addTreeSelectionListener(this.treeSelectionEventSupport_);
        }
    }

    private class VActionContext_
    implements VActionContext,
    Serializable {
        private VActionContext_() {
        }

        public boolean getConfirm() {
            return AS400TreePane.this.confirm_;
        }

        public Frame getFrame() {
            return VUtilities.getFrame(AS400TreePane.this);
        }

        public CellEditor startEditing(VObject vObject, Object object) {
            if (vObject == null) {
                throw new NullPointerException("object");
            }
            if (object == null) {
                throw new NullPointerException("propertyIdentifier");
            }
            if (!AS400TreePane.this.allowActions_) {
                return null;
            }
            if (AS400TreePane.this.tree_.getPathBounds(AS400TreePane.this.model_.getPath(vObject)) != null) {
                AS400TreePane.this.tree_.startEditingAtPath(AS400TreePane.this.model_.getPath(vObject));
            }
            return AS400TreePane.this.tree_.getCellEditor();
        }
    }

    private class VPane_
    implements VPane,
    Serializable {
        private VPane_() {
        }

        public VNode getRoot() {
            return AS400TreePane.this.getRoot();
        }

        public VObject getObjectAt(Point point) {
            VObject vObject = null;
            TreePath treePath = AS400TreePane.this.tree_.getClosestPathForLocation(point.x, point.y);
            Rectangle rectangle = AS400TreePane.this.tree_.getPathBounds(treePath);
            if (rectangle.contains(point)) {
                vObject = (VObject)treePath.getLastPathComponent();
            }
            return vObject;
        }

        public void setRoot(VNode vNode) throws PropertyVetoException {
            AS400TreePane.this.setRoot(vNode);
        }
    }
}

