/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

class IFSRenameAction
implements VAction,
CellEditorListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String text_ = ResourceLoader.getText("ACTION_RENAME");
    private boolean enabled_ = true;
    private IFSFile file_ = null;
    private VObject object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSRenameAction(VObject vObject, IFSFile iFSFile) {
        this.object_ = vObject;
        this.file_ = iFSFile;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public void editingStopped(ChangeEvent changeEvent) {
        CellEditor cellEditor = (CellEditor)changeEvent.getSource();
        cellEditor.removeCellEditorListener(this);
        String string = cellEditor.getCellEditorValue().toString();
        if (Trace.isTraceOn()) {
            Trace.log(3, "Renaming file or directory [" + this.file_.getName() + "] to [" + string + "].");
        }
        this.workingEventSupport_.fireStartWorking();
        boolean bl = false;
        try {
            if (!this.file_.exists()) {
                this.errorEventSupport_.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_FOUND")));
                this.workingEventSupport_.fireStopWorking();
                bl = true;
                this.objectEventSupport_.fireObjectDeleted(this.object_);
            } else if (this.file_.renameTo(new IFSFile(this.file_.getSystem(), this.file_.getParent(), string))) {
                this.objectEventSupport_.fireObjectChanged(this.object_);
            } else {
                this.errorEventSupport_.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_RENAMED")));
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        if (!bl) {
            this.workingEventSupport_.fireStopWorking();
        }
    }

    public String getText() {
        return text_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext vActionContext) {
        CellEditor cellEditor = vActionContext.startEditing(this.object_, VObject.NAME_PROPERTY);
        if (cellEditor != null) {
            cellEditor.addCellEditorListener(this);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
    }

    public String toString() {
        return text_;
    }
}

