/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class QueuedMessageReplyAction
extends DialogAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String replyPrompt_ = ResourceLoader.getText("MESSAGE_REPLY") + ": ";
    private static final String text_ = ResourceLoader.getText("ACTION_REPLY");
    private QueuedMessage message_ = null;
    private MessageQueue queue_ = null;
    private JTextField replyText_ = new JTextField(" ", 40);

    public QueuedMessageReplyAction(VObject vObject, QueuedMessage queuedMessage, MessageQueue messageQueue) {
        super(vObject);
        this.message_ = queuedMessage;
        this.queue_ = messageQueue;
    }

    public String getText() {
        return text_;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.message_.getType() == 5;
    }

    public JComponent getInputComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        VUtilities.constrain(new JLabel(replyPrompt_), jPanel, gridBagLayout, 0, 0, 1, 1);
        String string = this.message_.getDefaultReply();
        if (string != null) {
            this.replyText_.setText(string);
        }
        VUtilities.constrain(this.replyText_, jPanel, gridBagLayout, 1, 0, 1, 1);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform2() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Replying to queued message [" + this.message_.getID() + "] in message queue [" + this.queue_ + "].");
        }
        this.fireStartWorking();
        try {
            this.queue_.reply(this.message_.getKey(), this.replyText_.getText());
        }
        catch (Exception exception) {
            this.fireError(exception);
        }
        finally {
            this.fireStopWorking();
            this.fireObjectDeleted();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }
}

