/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.RecordListData;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RecordListFormPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    private transient JLabel recordLabel_;
    private transient JLabel recordNumber_;
    transient JButton firstButton_;
    transient JButton lastButton_;
    transient JButton nextButton_;
    transient JButton previousButton_;
    transient JButton refreshButton_;
    private transient JLabel[] labels_ = new JLabel[0];
    private transient JTextField[] values_ = new JTextField[0];
    private transient DBCellRenderer[] formatter_ = new DBCellRenderer[0];
    private JLabel status_;
    private JPanel dataArea_;
    private DBCellRenderer leftCell_ = new DBCellRenderer(2);
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_HEX = 2;
    private transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient int current_ = -1;
    private RecordListData tableData_ = new RecordListData();
    transient boolean error_;
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);

    public RecordListFormPane() {
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public RecordListFormPane(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.setSystem(aS400);
        this.tableData_.setFileName(string);
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public RecordListFormPane(AS400 aS400, String string, Object[] objectArray, int n) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.setSystem(aS400);
        this.tableData_.setFileName(string);
        this.tableData_.setKeyed(true);
        this.tableData_.setKey(objectArray);
        this.tableData_.setSearchType(n);
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.addActionCompletedListener(actionCompletedListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void close() {
        this.tableData_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFirst() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayLast() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.error_ = false;
            this.current_ = this.tableData_.getNumberOfRows() - 1;
            if (this.error_) {
                this.current_ = this.tableData_.getLastRecordProcessed();
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayNext() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.current_ = this.tableData_.getAllRecordsProcessed() ? (this.current_ + 1 == this.tableData_.getNumberOfRows() ? 0 : ++this.current_) : ++this.current_;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPrevious() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            if (this.current_ < 1) {
                this.error_ = false;
                this.current_ = this.tableData_.getNumberOfRows() - 1;
                if (this.error_) {
                    this.current_ = this.tableData_.getLastRecordProcessed();
                }
            } else {
                --this.current_;
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    public synchronized int getCurrentRecord() {
        return this.current_;
    }

    public String getFileName() {
        String string = this.tableData_.getFileName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public Object[] getKey() {
        return this.tableData_.getKey();
    }

    public boolean getKeyed() {
        return this.tableData_.getKeyed();
    }

    public synchronized String getLabelText(int n) {
        return this.labels_[n].getText();
    }

    public int getSearchType() {
        return this.tableData_.getSearchType();
    }

    public AS400 getSystem() {
        return this.tableData_.getSystem();
    }

    public synchronized String getStringValueAt(int n) {
        return this.values_[n].getText();
    }

    public synchronized Object getValueAt(int n) {
        return this.tableData_.getValueAt(this.current_, n);
    }

    private void init() {
        this.recordLabel_ = new JLabel(ResourceLoader.getText("DBFORM_LABEL_RECORD_NUMBER"));
        this.recordNumber_ = new JLabel();
        String string = ResourceLoader.getText("DBFORM_TOOLTIP_FIRST");
        this.firstButton_ = new JButton(ResourceLoader.getIcon("FirstIcon.gif", string));
        this.firstButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_LAST");
        this.lastButton_ = new JButton(ResourceLoader.getIcon("LastIcon.gif", string));
        this.lastButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_NEXT");
        this.nextButton_ = new JButton(ResourceLoader.getIcon("NextIcon.gif", string));
        this.nextButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_PREVIOUS");
        this.previousButton_ = new JButton(ResourceLoader.getIcon("PreviousIcon.gif", string));
        this.previousButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_REFRESH");
        this.refreshButton_ = new JButton(ResourceLoader.getIcon("RefreshIcon.gif", string));
        this.refreshButton_.setToolTipText(string);
        ButtonListener_ buttonListener_ = new ButtonListener_();
        this.firstButton_.addActionListener(buttonListener_);
        this.lastButton_.addActionListener(buttonListener_);
        this.nextButton_.addActionListener(buttonListener_);
        this.previousButton_.addActionListener(buttonListener_);
        this.refreshButton_.addActionListener(buttonListener_);
        this.dataArea_ = new JPanel();
        this.dataArea_.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.status_ = new JLabel(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.firstButton_);
        jPanel.add(this.previousButton_);
        jPanel.add(this.nextButton_);
        jPanel.add(this.lastButton_);
        jPanel.add(this.refreshButton_);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(this.status_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("South", jPanel2);
        this.add("South", jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.recordLabel_);
        jPanel3.add(this.recordNumber_);
        this.add("North", jPanel3);
        this.add("Center", this.dataArea_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        RecordListFormPane recordListFormPane = this;
        synchronized (recordListFormPane) {
            this.dataArea_.removeAll();
            IllegalStateException illegalStateException = null;
            this.error_ = false;
            if (this.tableData_.getSystem() == null) {
                illegalStateException = new IllegalStateException("system");
                this.error_ = true;
            } else if (this.tableData_.getFileName() == null) {
                illegalStateException = new IllegalStateException("fileName");
                this.error_ = true;
            } else {
                this.tableData_.load();
            }
            if (this.error_) {
                this.values_ = new JTextField[0];
                this.labels_ = new JLabel[0];
                this.current_ = -1;
                this.refreshScreen();
                if (illegalStateException != null) {
                    throw illegalStateException;
                }
                return;
            }
            int n = this.tableData_.getNumberOfColumns();
            this.labels_ = new JLabel[n];
            this.values_ = new JTextField[n];
            DBCellRenderer dBCellRenderer = new DBCellRenderer(2);
            this.formatter_ = new DBCellRenderer[n];
            this.dataArea_.setLayout(new GridLayout(n, 1));
            Class<?> clazz = new byte[0].getClass();
            for (int i = 0; i < n; ++i) {
                JLabel jLabel;
                this.labels_[i] = jLabel = new JLabel(this.tableData_.getColumnLabel(i));
                Object object = null;
                int n2 = 0;
                while (!this.tableData_.getAllRecordsProcessed() && object == null) {
                    object = this.tableData_.getValueAt(n2, i);
                    ++n2;
                }
                int n3 = object != null && object.getClass() == clazz ? 2 : 1;
                n2 = this.tableData_.getColumnDisplaySize(i);
                JTextField jTextField = new JTextField(n2);
                jTextField.setEditable(false);
                this.values_[i] = jTextField;
                this.formatter_[i] = dBCellRenderer;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(0));
                jPanel.add(this.labels_[i]);
                jPanel.add(this.values_[i]);
                this.dataArea_.add(jPanel);
            }
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.labels_ = new JLabel[0];
        this.values_ = new JTextField[0];
        this.formatter_ = new DBCellRenderer[0];
        this.current_ = -1;
        this.init();
    }

    private void refreshScreen() {
        if (this.values_.length == 0) {
            this.current_ = -1;
        } else if (this.tableData_.getAllRecordsProcessed() && this.tableData_.getNumberOfRows() == 0) {
            this.current_ = -1;
        }
        if (this.current_ == -1) {
            this.status_.setText(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
            int n = this.values_.length;
            for (int i = 0; i < n; ++i) {
                this.values_[i].setText("");
            }
            this.recordNumber_.setText("");
        } else {
            int n = this.values_.length;
            for (int i = 0; i < n; ++i) {
                Object object = this.tableData_.getValueAt(this.current_, i);
                this.values_[i].setText(this.formatter_[i].getText(object));
            }
            this.recordNumber_.setText(String.valueOf(this.current_ + 1));
            this.recordNumber_.setSize(this.recordNumber_.getPreferredSize());
            this.status_.setText("");
        }
        this.validate();
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.removeActionCompletedListener(actionCompletedListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void setFileName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        String string2 = this.getFileName();
        this.fireVetoableChange("fileName", string2, string);
        this.tableData_.setFileName(string);
        this.firePropertyChange("fileName", string2, string);
    }

    public void setKey(Object[] objectArray) throws PropertyVetoException {
        Object[] objectArray2 = this.getKey();
        this.fireVetoableChange("key", objectArray2, objectArray);
        this.tableData_.setKey(objectArray);
        this.firePropertyChange("key", objectArray2, objectArray);
    }

    public void setKeyed(boolean bl) throws PropertyVetoException {
        Boolean bl2 = new Boolean(this.getKeyed());
        this.fireVetoableChange("keyed", bl2, new Boolean(bl));
        this.tableData_.setKeyed(bl);
        this.firePropertyChange("keyed", bl2, new Boolean(bl));
    }

    public void setLabelText(int n, String string) {
        this.labels_[n].setText(string);
    }

    public void setSearchType(int n) throws PropertyVetoException {
        int n2 = this.getSearchType();
        this.fireVetoableChange("searchType", new Integer(n2), new Integer(n));
        this.tableData_.setSearchType(n);
        this.firePropertyChange("searchType", new Integer(n2), new Integer(n));
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.getSystem();
        this.fireVetoableChange("system", aS4002, aS400);
        this.tableData_.setSystem(aS400);
        this.firePropertyChange("system", aS4002, aS400);
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == RecordListFormPane.this.firstButton_) {
                RecordListFormPane.this.displayFirst();
            } else if (object == RecordListFormPane.this.lastButton_) {
                RecordListFormPane.this.displayLast();
            } else if (object == RecordListFormPane.this.nextButton_) {
                RecordListFormPane.this.displayNext();
            } else if (object == RecordListFormPane.this.previousButton_) {
                RecordListFormPane.this.displayPrevious();
            } else if (object == RecordListFormPane.this.refreshButton_) {
                RecordListFormPane.this.load();
            }
        }
    }

    private class ErrorListener_
    implements ErrorListener {
        private ErrorListener_() {
        }

        public void errorOccurred(ErrorEvent errorEvent) {
            RecordListFormPane.this.error_ = true;
            RecordListFormPane.this.errorListeners_.fireError(errorEvent.getException());
        }
    }
}

