/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;

public class ParentChecker {
    private IResource[] fResources;
    private IEGLElement[] fEGLElements;

    public ParentChecker(IResource[] resources, IEGLElement[] eglElements) {
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)eglElements);
        this.fResources = resources;
        this.fEGLElements = eglElements;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fEGLElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.eglElementsHaveCommonParent()) {
            return null;
        }
        if (this.fEGLElements.length == 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            Assert.isNotNull((Object)commonResourceParent);
            IEGLElement convertedToEGL = EGLCore.create((IResource)commonResourceParent);
            if (convertedToEGL != null && convertedToEGL.exists()) {
                return convertedToEGL;
            }
            return commonResourceParent;
        }
        if (this.fResources.length == 0) {
            return this.getCommonEGLElementParent();
        }
        IResource commonResourceParent = this.getCommonResourceParent();
        IEGLElement commonEGLElementParent = this.getCommonEGLElementParent();
        Assert.isNotNull((Object)commonEGLElementParent);
        Assert.isNotNull((Object)commonResourceParent);
        IEGLElement convertedToEGL = EGLCore.create((IResource)commonResourceParent);
        if (3 == convertedToEGL.getElementType()) {
            convertedToEGL = ((IPackageFragmentRoot)convertedToEGL).getPackageFragment("");
        }
        if (convertedToEGL == null || !convertedToEGL.exists() || !commonEGLElementParent.equals(convertedToEGL)) {
            return null;
        }
        return commonEGLElementParent;
    }

    private IEGLElement getCommonEGLElementParent() {
        Assert.isNotNull((Object)this.fEGLElements);
        Assert.isTrue((this.fEGLElements.length > 0 ? 1 : 0) != 0);
        return this.fEGLElements[0].getParent();
    }

    private IResource getCommonResourceParent() {
        Assert.isNotNull((Object)this.fResources);
        Assert.isTrue((this.fResources.length > 0 ? 1 : 0) != 0);
        return this.fResources[0].getParent();
    }

    private boolean eglElementsHaveCommonParent() {
        if (this.fEGLElements.length == 0) {
            return true;
        }
        IEGLElement firstParent = this.fEGLElements[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fEGLElements.length) {
            if (!firstParent.equals(this.fEGLElements[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer firstParent = this.fResources[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fResources.length) {
            if (!firstParent.equals((Object)this.fResources[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public IEGLElement[] getEGLElements() {
        return this.fEGLElements;
    }

    public void removeElementsWithAncestorsOnList(boolean removeOnlyEGLElements) {
        if (!removeOnlyEGLElements) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfEGLElements();
        }
        this.removeEGLElementsDescendantsOfEGLElements();
    }

    private void removeResourcesDescendantsOfEGLElements() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fEGLElements.length) {
                IEGLElement superElements = this.fEGLElements[j];
                if (ParentChecker.isDescendantOf(subResource, superElements)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    private void removeEGLElementsDescendantsOfEGLElements() {
        ArrayList<IEGLElement> subElements = new ArrayList<IEGLElement>(3);
        int i = 0;
        while (i < this.fEGLElements.length) {
            IEGLElement subElement = this.fEGLElements[i];
            int j = 0;
            while (j < this.fEGLElements.length) {
                IEGLElement superElement = this.fEGLElements[j];
                if (ParentChecker.isDescendantOf(subElement, superElement)) {
                    subElements.add(subElement);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subElements.toArray(new IEGLElement[subElements.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fResources.length) {
                IResource superResource = this.fResources[j];
                if (ParentChecker.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    public static boolean isDescendantOf(IResource subResource, IEGLElement superElement) {
        IContainer parent = subResource.getParent();
        while (parent != null) {
            IEGLElement el = EGLCore.create((IResource)parent);
            if (el != null && el.exists() && el.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IEGLElement subElement, IEGLElement superElement) {
        if (subElement.equals(superElement)) {
            return false;
        }
        IEGLElement parent = subElement.getParent();
        while (parent != null) {
            if (parent.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IEGLElement[] elementsToNotDelete) {
        this.fEGLElements = ReorgUtils.setMinus(this.fEGLElements, elementsToNotDelete);
    }
}

