/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.preview;

import java.util.List;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PreviewConvertContext {
    private Logger _log = PDPlugin.getLogger(PreviewConvertContext.class);
    private IDOMDocument _destDocument;

    public PreviewConvertContext(IDOMDocument destDocument) {
        this._destDocument = destDocument;
    }

    public Node previewConvert(Node ele) {
        if (ele instanceof Element) {
            return this.previewConvertElement((Element)ele);
        }
        if (ele instanceof Text) {
            return this.createText((Text)ele);
        }
        return null;
    }

    private Node createText(Text text) {
        Text previewText = this._destDocument.createTextNode(text.getData());
        try {
            ((IDOMText)previewText).setSource(((IDOMText)text).getSource());
        }
        catch (InvalidCharacterException e) {
            this._log.info("PreviewConvertContext.Error.0", (Throwable)e);
        }
        return previewText;
    }

    protected Node previewConvertElement(Element ele) {
        ITagConverter converter = this.createTagConverter(ele);
        if (!converter.isVisualByHTML()) {
            return null;
        }
        converter.convertRefresh(null);
        Element result = converter.getResultElement();
        List children = converter.getChildModeList();
        if (children != null) {
            int i = 0;
            int size = children.size();
            while (i < size) {
                ConvertPosition position;
                Node childPreview;
                Node child = (Node)children.get(i);
                if (child != null && (childPreview = this.previewConvert(child)) != null && (position = converter.getChildVisualPosition(child)) != null) {
                    NodeList childNodes = position.getParentNode().getChildNodes();
                    if (childNodes.getLength() > position.getIndex()) {
                        Node item = childNodes.item(position.getIndex());
                        position.getParentNode().insertBefore(childPreview, item);
                    } else {
                        position.getParentNode().appendChild(childPreview);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private ITagConverter createTagConverter(Element ele) {
        return DTManager.getInstance().getTagConverter(ele, 1, this._destDocument);
    }
}

