/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.wst.common.componentcore.internal.ModuleMigratorManager;
import org.eclipse.wst.web.ui.internal.WSTWebUIPlugin;

public final class ModuleCoreValidatorMarkerResolutions
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{new ModuleCoreMigrationResolution(marker)};
    }

    private class ModuleCoreMigrationResolution
    extends WorkbenchMarkerResolution {
        private final IMarker theMarker;
        private final String MARKERTYPE = "org.eclipse.wst.common.modulecore.ModuleCoreValidatorMarker";

        public ModuleCoreMigrationResolution(IMarker marker) {
            this.theMarker = marker;
        }

        public String getLabel() {
            return Resources.migrateMetaData;
        }

        public void run(IMarker marker) {
            IProject proj = marker.getResource().getProject();
            try {
                ModuleMigratorManager manager = ModuleMigratorManager.getManager((IProject)proj);
                if (!manager.isMigrating() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                    manager.migrateOldMetaData(proj, true);
                }
            }
            catch (Exception e) {
                WSTWebUIPlugin.logError(e);
            }
        }

        public String getDescription() {
            return Resources.migrateMetaData;
        }

        public Image getImage() {
            return null;
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList<IMarker> marks = new ArrayList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                try {
                    if (marker.getType().equals("org.eclipse.wst.common.modulecore.ModuleCoreValidatorMarker") && !marker.equals((Object)this.theMarker)) {
                        marks.add(marker);
                    }
                }
                catch (CoreException e) {
                    WSTWebUIPlugin.logError(e);
                }
                ++i;
            }
            return marks.toArray(new IMarker[marks.size()]);
        }
    }

    private static final class Resources
    extends NLS {
        public static String migrateMetaData;

        static {
            Resources.initializeMessages((String)ModuleCoreValidatorMarkerResolutions.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

