/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class ImageList {
    long[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new long[4];
    }

    public int add(Image image) {
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null && this.images[index].isDisposed()) {
                OS.g_object_unref(this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0L;
            }
            if (this.images[index] == null) break;
            ++index;
        }
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
            long[] newPixbufs = new long[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, newPixbufs, 0, this.pixbufs.length);
            this.pixbufs = newPixbufs;
        }
        this.set(index, image);
        return index;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        int index = 0;
        while (index < this.pixbufs.length) {
            if (this.pixbufs[index] != 0L) {
                OS.g_object_unref(this.pixbufs[index]);
            }
            ++index;
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    long getPixbuf(int index) {
        return this.pixbufs[index];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int indexOf(long pixbuf) {
        if (pixbuf == 0L) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (pixbuf == this.pixbufs[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int index, Image image) {
        int count = this.images.length;
        if (index < 0 || index >= count) {
            return;
        }
        if (image != null) {
            this.set(index, image);
        } else {
            this.images[index] = null;
            if (this.pixbufs[index] != 0L) {
                OS.g_object_unref(this.pixbufs[index]);
            }
            this.pixbufs[index] = 0L;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                OS.g_object_unref(this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0L;
            }
            ++index;
        }
    }

    void set(int index, Image image) {
        long oldPixbuf;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, w, h);
        long pixbuf = Display.createPixbuf(image);
        if (this.width == -1 || this.height == -1) {
            this.width = w[0];
            this.height = h[0];
        }
        if (w[0] != this.width || h[0] != this.height) {
            long scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, this.width, this.height, 2);
            OS.g_object_unref(pixbuf);
            pixbuf = scaledPixbuf;
        }
        if ((oldPixbuf = this.pixbufs[index]) != 0L) {
            if (this.images[index] == image) {
                OS.gdk_pixbuf_copy_area(pixbuf, 0, 0, this.width, this.height, oldPixbuf, 0, 0);
                OS.g_object_unref(pixbuf);
                pixbuf = oldPixbuf;
            } else {
                OS.g_object_unref(oldPixbuf);
            }
        }
        this.pixbufs[index] = pixbuf;
        this.images[index] = image;
    }

    public int size() {
        int result = 0;
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null) {
                if (this.images[index].isDisposed()) {
                    OS.g_object_unref(this.pixbufs[index]);
                    this.images[index] = null;
                    this.pixbufs[index] = 0L;
                }
                if (this.images[index] != null) {
                    ++result;
                }
            }
            ++index;
        }
        return result;
    }
}

