/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.rui.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.rui.messages.RUIResourceKeys;

public class RUIPropertiesLibraryValidator
implements IAnnotationValidationRule {
    public void validate(Node errorNode, Node target, Element targetElement, Map<String, Object> allAnnotationsAndFields, final IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            public boolean visit(Library library) {
                return true;
            }

            public boolean visit(NestedFunction nestedFunction) {
                problemRequestor.acceptProblem((Node)nestedFunction, 2066, 2, new String[0], RUIResourceKeys.getResourceBundleForKeys());
                return false;
            }

            public boolean visit(UseStatement useStatement) {
                problemRequestor.acceptProblem((Node)useStatement, 2066, 2, new String[0], RUIResourceKeys.getResourceBundleForKeys());
                return false;
            }

            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                if (!RUIPropertiesLibraryValidator.this.isValidInRUIPropertiesLibrary(classDataDeclaration)) {
                    problemRequestor.acceptProblem((Node)classDataDeclaration, 2066, 2, new String[0], RUIResourceKeys.getResourceBundleForKeys());
                }
                return false;
            }
        };
        target.accept((IASTVisitor)visitor);
    }

    private boolean isValidInRUIPropertiesLibrary(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.isConstant() || classDataDeclaration.isPrivate()) {
            return false;
        }
        Type type = classDataDeclaration.getType().resolveType();
        if (type == null) {
            return false;
        }
        return TypeUtils.Type_STRING.equals((Type)type.getClassifier()) != false;
    }
}

