/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionEvent;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionParticipant;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorSelectionParticipant
implements JpaSelectionParticipant {
    private final JpaSelectionManager selectionManager;
    final ITextEditor textEditor;
    private final IPropertyListener editorInputListener;
    private final ISelectionChangedListener editorSelectionListener;
    private JpaSelection currentSelection;
    private boolean forwardSelection = true;

    public TextEditorSelectionParticipant(JpaSelectionManager selectionManager, ITextEditor textEditor) {
        this.selectionManager = selectionManager;
        this.textEditor = textEditor;
        this.editorInputListener = new EditorInputListener();
        this.textEditor.addPropertyListener(this.editorInputListener);
        this.editorSelectionListener = new EditorSelectionListener();
        this.getPostSelectionProvider().addPostSelectionChangedListener(this.editorSelectionListener);
        this.currentSelection = this.calculateSelection();
    }

    public JpaSelection getSelection() {
        return this.currentSelection;
    }

    public void selectionChanged(JpaSelectionEvent evt) {
        JpaSelection newSelection = evt.getSelection();
        if (newSelection == JpaSelection.NULL_SELECTION || newSelection.equals(this.currentSelection)) {
            return;
        }
        if (this.getActiveTextEditor() != this.textEditor) {
            return;
        }
        this.forwardSelection = false;
        TextRange textRange = newSelection.getSelectedNode().getSelectionTextRange();
        if (textRange != null) {
            this.textEditor.selectAndReveal(textRange.getOffset(), textRange.getLength());
            this.currentSelection = newSelection;
        }
        this.forwardSelection = true;
    }

    public boolean disposeOnHide() {
        return true;
    }

    public void dispose() {
        this.textEditor.removePropertyListener(this.editorInputListener);
        this.getPostSelectionProvider().removePostSelectionChangedListener(this.editorSelectionListener);
    }

    protected JpaSelection calculateSelection() {
        ISelection selection = this.textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return JpaSelection.NULL_SELECTION;
        }
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile == null) {
            return JpaSelection.NULL_SELECTION;
        }
        return this.buildSelection(jpaFile.getStructureNode(((ITextSelection)selection).getOffset()));
    }

    protected JpaSelection buildSelection(JpaStructureNode selectedNode) {
        return selectedNode == null ? JpaSelection.NULL_SELECTION : new DefaultJpaSelection(selectedNode);
    }

    protected IWorkbenchPage getActivePage() {
        return this.textEditor.getEditorSite().getWorkbenchWindow().getActivePage();
    }

    protected IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage = this.getActivePage();
        return activePage == null ? null : activePage.getActivePart();
    }

    protected IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = this.getActivePage();
        return activePage == null ? null : activePage.getActiveEditor();
    }

    protected ITextEditor getActiveTextEditor() {
        return this.getTextEditor((IWorkbenchPart)this.getActiveEditor());
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        return part == null ? null : (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    protected JpaFile getJpaFile() {
        IEditorInput input = this.textEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return JptJpaCorePlugin.getJpaFile((IFile)((IFileEditorInput)input).getFile());
    }

    protected IPostSelectionProvider getPostSelectionProvider() {
        return (IPostSelectionProvider)this.textEditor.getSelectionProvider();
    }

    protected void editorInputChanged() {
        this.selectionChanged();
    }

    protected void editorSelectionChanged(SelectionChangedEvent event) {
        IWorkbenchPart activePart = this.getActivePart();
        if (this.getTextEditor(activePart) != this.textEditor && this.selectionManager.isRegistered(activePart)) {
            if (this.currentSelection.isEmpty()) {
                return;
            }
            this.forwardSelection = false;
            TextRange textRange = this.currentSelection.getSelectedNode().getSelectionTextRange();
            if (textRange != null) {
                this.textEditor.selectAndReveal(textRange.getOffset(), textRange.getLength());
            }
            this.forwardSelection = true;
            return;
        }
        this.selectionChanged();
    }

    protected void selectionChanged() {
        JpaSelection newSelection = this.calculateSelection();
        if (newSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        if (this.forwardSelection) {
            this.selectionManager.select(newSelection, this);
        }
    }

    protected class EditorInputListener
    implements IPropertyListener {
        protected EditorInputListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source == TextEditorSelectionParticipant.this.textEditor && propId == 258) {
                TextEditorSelectionParticipant.this.editorInputChanged();
            }
        }
    }

    protected class EditorSelectionListener
    implements ISelectionChangedListener {
        protected EditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextEditorSelectionParticipant.this.editorSelectionChanged(event);
        }
    }
}

