/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.ext;

import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.egl2mof.AbstractElementGenerator;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.GetByPositionStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlActionStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlAddStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlCloseStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlDeleteStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlExecuteStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlFactory;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlForEachStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlGetByKeyStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlOpenStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlPrepareStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlReplaceStatement;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class SQLActionStatementGenerator
extends AbstractElementGenerator {
    SqlFactory factory = SqlFactory.INSTANCE;

    public SQLActionStatementGenerator() {
        super(null);
    }

    public SQLActionStatementGenerator(IEnvironment env) {
        super(env);
    }

    private void doCommonVisit(Statement node, final SqlActionStatement stmt) {
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept((IASTVisitor)SQLActionStatementGenerator.this);
                stmt.setDataSource((Expression)SQLActionStatementGenerator.this.stack.pop());
                return false;
            }

            public boolean visit(WithInlineSQLClause sqlStmt) {
                String sql = sqlStmt.getSqlStmt().getValue();
                stmt.setHasExplicitSql(true);
                stmt.setSqlString(sql);
                return false;
            }

            public boolean visit(WithExpressionClause sqlStmt) {
                sqlStmt.getExpression().accept((IASTVisitor)SQLActionStatementGenerator.this);
                stmt.setPreparedStatement((Expression)SQLActionStatementGenerator.this.stack.pop());
                return false;
            }

            public boolean visit(InlineSQLStatement sqlStmt) {
                String sql = sqlStmt.getValue();
                stmt.setHasExplicitSql(true);
                stmt.setSqlString(sql);
                return false;
            }
        });
    }

    public boolean visit(AddStatement node) {
        SqlAddStatement stmt = this.factory.createSqlAddStatement();
        this.stack.push(stmt);
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }

    public boolean visit(CloseStatement node) {
        SqlCloseStatement stmt = this.factory.createSqlCloseStatement();
        this.stack.push(stmt);
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.GetByPositionStatement getByPositionStatement) {
        GetByPositionStatement stmt = this.factory.createGetByPositionStatement();
        this.stack.push(stmt);
        return false;
    }

    public boolean visit(DeleteStatement node) {
        SqlDeleteStatement stmt = this.factory.createSqlDeleteStatement();
        this.stack.push(stmt);
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }

    public boolean visit(ExecuteStatement node) {
        SqlExecuteStatement stmt = this.factory.createSqlExecuteStatement();
        this.stack.push(stmt);
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }

    public boolean visit(ForEachStatement forEachStatement) {
        SqlForEachStatement forEachStmt = this.factory.createSqlForEachStatement();
        this.stack.push(forEachStmt);
        this.doCommonVisit((Statement)forEachStatement, forEachStmt);
        for (Node expr : forEachStatement.getTargets()) {
            expr.accept((IASTVisitor)this);
            forEachStmt.getTargets().add((Expression)this.stack.pop());
        }
        return false;
    }

    public boolean visit(GetByKeyStatement node) {
        SqlGetByKeyStatement stmt = this.factory.createSqlGetByKeyStatement();
        this.stack.push(stmt);
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }

    public boolean visit(OpenStatement node) {
        SqlOpenStatement stmt = this.factory.createSqlOpenStatement();
        this.stack.push(stmt);
        node.getResultSet().accept((IASTVisitor)this);
        stmt.getTargets().add((Expression)this.stack.pop());
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }

    public boolean visit(PrepareStatement node) {
        SqlPrepareStatement stmt = this.factory.createSqlPrepareStatement();
        this.stack.push(stmt);
        if (node.getSqlStmt() != null) {
            node.getSqlStmt().accept((IASTVisitor)this);
            stmt.setPreparedStatement((Expression)this.stack.pop());
            stmt.getTargets().add(stmt.getPreparedStatement());
        }
        if (node.getWithClause() != null) {
            node.getWithClause().accept((IASTVisitor)this);
            if (node.getWithClause().isWithExpression()) {
                stmt.setSqlStringExpr((Expression)this.stack.pop());
            }
            if (node.getWithClause().isWithInlineSQL()) {
                InlineSQLStatement inline = ((WithInlineSQLClause)node.getWithClause()).getSqlStmt();
                String sql = inline.getValue().replaceAll("[\\n\\r]", " ");
                stmt.setSqlString(sql);
            }
        }
        return false;
    }

    public boolean visit(ReplaceStatement node) {
        SqlReplaceStatement stmt = this.factory.createSqlReplaceStatement();
        this.stack.push(stmt);
        this.doCommonVisit((Statement)node, stmt);
        return false;
    }
}

