/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.ext;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class Utils {
    private static final String SQLResultSetMofKey = "egl:eglx.persistence.sql.SQLResultSet";
    private static final String SQLDataSourceMofKey = "egl:eglx.persistence.sql.SQLDataSource";
    private static final String SQLStatementMofKey = "egl:eglx.persistence.sql.SQLStatement";

    private Utils() {
    }

    public static String getTableName(EGLClass entity) {
        String names;
        Annotation table = entity.getAnnotation("eglx.persistence.sql.Table");
        Annotation secTables = entity.getAnnotation("eglx.persistence.sql.SecondaryTables");
        String string = names = table == null ? entity.getCaseSensitiveName() : (String)table.getValue();
        if (secTables != null) {
            names = String.valueOf(names) + " t1";
            int i = 2;
            for (String tname : (List)secTables.getValue()) {
                names = String.valueOf(names) + ", " + tname + "t" + i;
                ++i;
            }
        }
        return names;
    }

    public static String getColumnName(Field field) {
        Annotation column = field.getAnnotation("eglx.persistence.sql.Column");
        String name = column != null && column.getValue("name") != null && !((String)column.getValue("name")).isEmpty() ? (String)column.getValue("name") : field.getCaseSensitiveName();
        EGLClass entity = (EGLClass)field.getContainer();
        Annotation secTables = entity.getAnnotation("eglx.persistence.sql.SecondaryTables");
        if (secTables != null) {
            String table = (String)column.getValue("table");
            if (table == null) {
                name = "t1." + name;
            } else {
                List tables = (List)secTables.getValue("tableNames");
                int index = 2;
                int i = 0;
                while (i < tables.size()) {
                    if (table.equalsIgnoreCase((String)tables.get(i))) {
                        index += i;
                        break;
                    }
                    ++i;
                }
                name = "t" + index + '.' + name;
            }
        }
        return name;
    }

    public static boolean isKeyField(Field field) {
        return field.getAnnotation("eglx.persistence.Id") != null;
    }

    public static boolean isGeneratedValue(Field field) {
        return field.getAnnotation("eglx.persistence.sql.GeneratedValue") != null;
    }

    public static boolean isAssociationField(Field field) {
        Type type = field.getType();
        if (type instanceof ArrayType) {
            return true;
        }
        return !Utils.isMappedSQLType((EGLClass)type.getClassifier());
    }

    public static boolean isTransient(Field field) {
        return field.getAnnotation("eglx.persistence.Transient") != null;
    }

    public static boolean isInsertable(Field field) {
        return !Utils.isGeneratedValue(field) && !Utils.isAssociationField(field) && !Utils.isTransient(field) && (field.getAnnotation("eglx.persistence.sql.Column") == null || (Boolean)field.getAnnotation("eglx.persistence.sql.Column").getValue("insertable") != false);
    }

    public static boolean isUpdateable(Field field) {
        return !Utils.isGeneratedValue(field) && !Utils.isKeyField(field) && !Utils.isAssociationField(field) && !Utils.isTransient(field) && (field.getAnnotation("eglx.persistence.sql.Column") == null || (Boolean)field.getAnnotation("eglx.persistence.sql.Column").getValue("updateable") != false);
    }

    public static boolean isReadable(Field field) {
        return !Utils.isAssociationField(field) && !Utils.isTransient(field);
    }

    public static boolean isSQLDataSource(Type type) {
        return TypeUtils.isTypeOrSubtypeOf((Type)type, (String)SQLDataSourceMofKey);
    }

    public static boolean isSQLResultSet(Type type) {
        return TypeUtils.isTypeOrSubtypeOf((Type)type, (String)SQLResultSetMofKey);
    }

    public static boolean isSQLStatement(Type type) {
        return TypeUtils.isTypeOrSubtypeOf((Type)type, (String)SQLStatementMofKey);
    }

    public static boolean isTextType(Classifier type) {
        return type.equals(TypeUtils.Type_STRING);
    }

    public static boolean isSQLDateTimeType(Classifier type) {
        return type.equals(TypeUtils.Type_DATE) != false || type.equals(TypeUtils.Type_TIME) != false || type.equals(TypeUtils.Type_TIMESTAMP) != false;
    }

    public static boolean isWrappedSQLType(Classifier type) {
        return Utils.isSQLDateTimeType(type) || type.equals(TypeUtils.Type_BLOB) != false || type.equals(TypeUtils.Type_CLOB) != false;
    }

    public static String getSQLTypeName(Classifier type) {
        String name = Utils.getSqlSimpleTypeName(type);
        if (name != null && Utils.isWrappedSQLType(type)) {
            name = "java.sql." + name;
        }
        return name;
    }

    public static String getSqlSimpleTypeName(Classifier type) {
        String name = null;
        if (type.equals(TypeUtils.Type_DATE).booleanValue()) {
            name = "Date";
        } else if (type.equals(TypeUtils.Type_TIME).booleanValue()) {
            name = "Time";
        } else if (type.equals(TypeUtils.Type_TIMESTAMP).booleanValue()) {
            name = "Timestamp";
        } else if (type.equals(TypeUtils.Type_BLOB).booleanValue()) {
            name = "Blob";
        } else if (type.equals(TypeUtils.Type_CLOB).booleanValue()) {
            name = "Clob";
        } else if (type.equals(TypeUtils.Type_BOOLEAN).booleanValue()) {
            name = "Boolean";
        } else if (type.equals(TypeUtils.Type_FLOAT).booleanValue()) {
            name = "Double";
        } else if (type.equals(TypeUtils.Type_SMALLFLOAT).booleanValue()) {
            name = "Float";
        } else if (type.equals(TypeUtils.Type_BIGINT).booleanValue()) {
            name = "Long";
        } else if (type.equals(TypeUtils.Type_INT).booleanValue()) {
            name = "Int";
        } else if (type.equals(TypeUtils.Type_SMALLINT).booleanValue()) {
            name = "Short";
        } else if (type.equals(TypeUtils.Type_DECIMAL).booleanValue()) {
            name = "BigDecimal";
        } else if (type.equals(TypeUtils.Type_STRING).booleanValue()) {
            name = "String";
        } else if (type.equals(TypeUtils.Type_BYTES).booleanValue()) {
            name = "Bytes";
        }
        return name;
    }

    public static String getSQLTypeConstant(Classifier type) {
        String constant = "java.sql.Types.";
        if (type.equals(TypeUtils.Type_DATE).booleanValue()) {
            constant = String.valueOf(constant) + "DATE";
        } else if (type.equals(TypeUtils.Type_TIME).booleanValue()) {
            constant = String.valueOf(constant) + "TIME";
        } else if (type.equals(TypeUtils.Type_TIMESTAMP).booleanValue()) {
            constant = String.valueOf(constant) + "TIMESTAMP";
        } else if (type.equals(TypeUtils.Type_BLOB).booleanValue()) {
            constant = String.valueOf(constant) + "BLOB";
        } else if (type.equals(TypeUtils.Type_CLOB).booleanValue()) {
            constant = String.valueOf(constant) + "CLOB";
        } else if (type.equals(TypeUtils.Type_BOOLEAN).booleanValue()) {
            constant = String.valueOf(constant) + "BOOLEAN";
        } else if (type.equals(TypeUtils.Type_FLOAT).booleanValue()) {
            constant = String.valueOf(constant) + "DOUBLE";
        } else if (type.equals(TypeUtils.Type_SMALLFLOAT).booleanValue()) {
            constant = String.valueOf(constant) + "FLOAT";
        } else if (type.equals(TypeUtils.Type_BIGINT).booleanValue()) {
            constant = String.valueOf(constant) + "BIGINT";
        } else if (type.equals(TypeUtils.Type_INT).booleanValue()) {
            constant = String.valueOf(constant) + "INTEGER";
        } else if (type.equals(TypeUtils.Type_SMALLINT).booleanValue()) {
            constant = String.valueOf(constant) + "SMALLINT";
        } else if (type.equals(TypeUtils.Type_DECIMAL).booleanValue()) {
            constant = String.valueOf(constant) + "DECIMAL";
        } else if (type.equals(TypeUtils.Type_STRING).booleanValue()) {
            constant = String.valueOf(constant) + "VARCHAR";
        } else if (type.equals(TypeUtils.Type_BYTES).booleanValue()) {
            constant = String.valueOf(constant) + "BINARY";
        }
        return constant;
    }

    public static boolean isMappedSQLType(EGLClass type) {
        return Utils.getSqlSimpleTypeName((Classifier)type) != null;
    }

    public static String getConvertToSQLConstructorOptions(EGLClass type) {
        if (type.equals(TypeUtils.Type_DATE).booleanValue() || type.equals(TypeUtils.Type_TIME).booleanValue() || type.equals(TypeUtils.Type_TIMESTAMP).booleanValue()) {
            return "getTimeInMillis()";
        }
        return "unsupportedConversion()";
    }

    public static boolean isCallStatement(String sqlStmt) {
        if (sqlStmt == null) {
            return false;
        }
        try {
            StringTokenizer parser = new StringTokenizer(sqlStmt);
            String stmtKind = parser.nextToken();
            return stmtKind.equalsIgnoreCase("call");
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public static boolean isComment(String sqlStmt) {
        try {
            StringTokenizer parser = new StringTokenizer(sqlStmt);
            String stmtKind = parser.nextToken();
            return stmtKind.startsWith("--");
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public static String removeCRLFs(String sqlString) {
        return sqlString.replaceAll("[\n\r\t]", " ");
    }

    public static String removeCommentsCRLFs(String sqlString) {
        StringBuilder out = new StringBuilder();
        StringReader in = new StringReader(sqlString);
        try {
            char c;
            boolean isComment = false;
            boolean couldBeComment = false;
            while ((c = (char)in.read()) != '\uffff') {
                if (couldBeComment && c != '-') {
                    out.append('-');
                    couldBeComment = false;
                }
                if (c == '-') {
                    if (couldBeComment) {
                        isComment = true;
                        couldBeComment = false;
                    } else {
                        couldBeComment = true;
                    }
                }
                if (isComment) {
                    while ((c = (char)in.read()) != '\n' && c != '\uffff') {
                    }
                    isComment = false;
                    continue;
                }
                if (couldBeComment || c == '\n' || c == '\r' || c == '\t') continue;
                out.append(c);
            }
            return out.toString();
        }
        catch (IOException iOException) {
            return sqlString;
        }
    }
}

