/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import java.util.ArrayList;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlOpenStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;

public class SqlOpenStatementImpl
extends SqlIOStatementImpl
implements SqlOpenStatement {
    @Override
    public Expression getResultSet() {
        return this.getTarget();
    }

    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    private String generateDefaultSqlString() {
        Expression target;
        EGLClass targetType;
        StringBuilder sql = new StringBuilder();
        if (this.getTargets().size() == 2 && !TypeUtils.isDynamicType((Type)(targetType = (EGLClass)(target = (Expression)this.getTargets().get(1)).getType().getClassifier()))) {
            sql.append("SELECT ");
            ArrayList<Field> idFields = new ArrayList<Field>();
            boolean doComma = false;
            for (Field f : targetType.getFields()) {
                if (Utils.isKeyField(f)) {
                    idFields.add(f);
                }
                if (!Utils.isReadable(f)) continue;
                if (doComma) {
                    sql.append(", ");
                }
                if (Utils.isTextType(f.getType().getClassifier())) {
                    sql.append("RTRIM(");
                    sql.append(Utils.getColumnName(f));
                    sql.append(")");
                } else {
                    sql.append(Utils.getColumnName(f));
                }
                if (doComma) continue;
                doComma = true;
            }
            sql.append(" FROM ");
            sql.append(Utils.getTableName(targetType));
            if (!idFields.isEmpty()) {
                sql.append(" WHERE ");
                boolean doAnd = false;
                for (Field f : idFields) {
                    if (doAnd) {
                        sql.append(" AND ");
                    }
                    sql.append(String.valueOf(Utils.getColumnName(f)) + " = ?");
                    if (doAnd) continue;
                    doAnd = true;
                }
            }
        }
        return sql.toString();
    }
}

