/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class DeleteStatementValidator
extends AbstractSqlStatementValidator {
    DeleteStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    UsingClause using;
    UsingKeysClause usingKeys;
    FromOrToExpressionClause from;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    ForExpressionClause forExpression;

    public DeleteStatementValidator(DeleteStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateDataSource();
        this.validateFor();
    }

    private void validateTarget() {
        Expression target = this.statement.getTarget();
        if (target != null) {
            Type targetType = target.resolveType();
            if (targetType != null && TypeUtils.isPrimitive((Type)targetType)) {
                targetType = this.getContainingType(target.resolveMember());
            }
            if (!this.isDataExpr(target) || targetType instanceof ArrayType) {
                this.problemRequestor.acceptProblem((Node)target, 8513, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (this.isAssociationExpression(target)) {
                this.problemRequestor.acceptProblem((Node)target, 8508, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (targetType != null && !this.isSingleTable(targetType)) {
                this.problemRequestor.acceptProblem((Node)target, 8515, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (this.from != null && targetType != null && this.withExpression == null && this.withInline == null && this.using == null && Utils.isSQLDataSource(this.from.getExpression().resolveType()) && !this.hasID(targetType)) {
                this.problemRequestor.acceptProblem((Node)target, 8509, 2, new String[]{targetType.getTypeSignature()}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void validateDataSource() {
        if (this.statement.getTarget() == null && this.from != null) {
            Type type = this.from.getExpression().resolveType();
            if (type != null && Utils.isSQLDataSource(type)) {
                if (this.withInline == null && this.withExpression == null) {
                    this.problemRequestor.acceptProblem((Node)this.statement, 8511, 2, new String[]{"eglx.persistence.sql.SQLDataSource"}, SQLResourceKeys.getResourceBundleForKeys());
                    return;
                }
            } else if (type != null && Utils.isSQLResultSet(type) && (this.withInline != null || this.withExpression != null || this.forExpression != null || this.using != null)) {
                this.problemRequestor.acceptProblem((Node)this.statement, 8512, 2, new String[]{"eglx.persistence.sql.SQLResultSet"}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void validateFor() {
        if (this.forExpression != null) {
            Type targetType;
            if (this.statement.getTarget() == null) {
                this.problemRequestor.acceptProblem((Node)this.forExpression, 8514, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (this.withExpression != null || this.withInline != null) {
                this.problemRequestor.acceptProblem((Node)this.statement, 8516, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            Type type = this.forExpression.getExpression().resolveType();
            if (type != null && (!this.isEntityWithID(type) || this.isAssociationExpression(this.forExpression.getExpression()))) {
                this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8502, 2, new String[]{this.forExpression.getExpression().getCanonicalString()}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (type != null && (targetType = this.statement.getTarget().resolveType()) != null && !targetType.equals(type).booleanValue()) {
                this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8507, 2, new String[]{this.forExpression.getExpression().getCanonicalString(), type.getTypeSignature(), targetType.getTypeSignature()}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (DeleteStatementValidator.this.withInline == null && DeleteStatementValidator.this.withExpression == null) {
                    DeleteStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"delete".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithExpressionClause withExpressionClause) {
                if (DeleteStatementValidator.this.withInline == null && DeleteStatementValidator.this.withExpression == null) {
                    DeleteStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"delete".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingClause usingClause) {
                if (DeleteStatementValidator.this.using == null) {
                    DeleteStatementValidator.this.using = usingClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"delete".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingKeysClause usingKeysClause) {
                if (DeleteStatementValidator.this.usingKeys == null) {
                    DeleteStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"delete".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (DeleteStatementValidator.this.from == null) {
                    DeleteStatementValidator.this.from = clause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"delete".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }

            public boolean visit(ForExpressionClause forExpressionClause) {
                if (DeleteStatementValidator.this.forExpression == null) {
                    DeleteStatementValidator.this.forExpression = forExpressionClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"delete".toUpperCase(), "for".toUpperCase()});
                }
                return false;
            }
        });
    }
}

