/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class ExecuteStatementValidator
extends AbstractSqlStatementValidator {
    ExecuteStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    UsingClause using;
    UsingKeysClause usingKeys;
    FromOrToExpressionClause from;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;

    public ExecuteStatementValidator(ExecuteStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateFrom();
    }

    private void validateFrom() {
        if (this.from != null) {
            Type type;
            if (this.withExpression != null && (type = this.withExpression.getExpression().resolveType()) != null && Utils.isSQLStatement(type)) {
                return;
            }
            type = this.from.getExpression().resolveType();
            if (type != null && !Utils.isSQLDataSource(type)) {
                this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, 2, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLDataSource"}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (ExecuteStatementValidator.this.withInline == null && ExecuteStatementValidator.this.withExpression == null) {
                    ExecuteStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"execute".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithExpressionClause withExpressionClause) {
                if (ExecuteStatementValidator.this.withInline == null && ExecuteStatementValidator.this.withExpression == null) {
                    ExecuteStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"execute".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingClause usingClause) {
                if (ExecuteStatementValidator.this.using == null) {
                    ExecuteStatementValidator.this.using = usingClause;
                } else {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"execute".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingKeysClause usingKeysClause) {
                if (ExecuteStatementValidator.this.usingKeys == null) {
                    ExecuteStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"execute".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (ExecuteStatementValidator.this.from == null) {
                    ExecuteStatementValidator.this.from = clause;
                } else {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"execute".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }
        });
    }
}

