/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.ErrorNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class ErrorTerminalNode
extends TerminalNode
implements ErrorNode {
    private String errorMessage;
    private ParseNode errorTerminal;

    public ErrorTerminalNode(int terminalType) {
        super(terminalType, null);
        this.errorMessage = this.getDefaultErrorMessage();
    }

    public ErrorTerminalNode(int terminalType, ParseNode errorTerminal) {
        super(terminalType, null);
        this.errorTerminal = errorTerminal;
        this.errorMessage = this.getDefaultErrorMessage();
    }

    @Override
    public String toString() {
        return "<" + EGLNodeNameUtility.getTerminalName(this.terminalType) + ">";
    }

    @Override
    public boolean isError() {
        return true;
    }

    private String getDefaultErrorMessage() {
        String text = String.valueOf(this.getText().trim()) + " is unexpected";
        if (this.errorTerminal == null) {
            return "Missing " + EGLNodeNameUtility.getTerminalName(this.terminalType);
        }
        if (this.terminalType == 4) {
            return text;
        }
        return String.valueOf(text) + ", expecting " + EGLNodeNameUtility.getTerminalName(this.terminalType) + " instead";
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getText() {
        return this.errorTerminal == null ? "" : this.errorTerminal.getText();
    }
}

