/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IParent;
import org.eclipse.edt.ide.core.model.IRegion;

public class Region
implements IRegion {
    protected ArrayList fRootElements = new ArrayList(1);

    @Override
    public void add(IEGLElement element) {
        if (!this.contains(element)) {
            this.removeAllChildren(element);
            this.fRootElements.add(element);
            this.fRootElements.trimToSize();
        }
    }

    @Override
    public boolean contains(IEGLElement element) {
        int size = this.fRootElements.size();
        ArrayList parents = this.getAncestors(element);
        int i = 0;
        while (i < size) {
            IEGLElement aTop = (IEGLElement)this.fRootElements.get(i);
            if (aTop.equals(element)) {
                return true;
            }
            int j = 0;
            int pSize = parents.size();
            while (j < pSize) {
                if (aTop.equals(parents.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private ArrayList getAncestors(IEGLElement element) {
        ArrayList<IEGLElement> parents = new ArrayList<IEGLElement>();
        IEGLElement parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    @Override
    public IEGLElement[] getElements() {
        int size = this.fRootElements.size();
        IEGLElement[] roots = new IEGLElement[size];
        int i = 0;
        while (i < size) {
            roots[i] = (IEGLElement)this.fRootElements.get(i);
            ++i;
        }
        return roots;
    }

    @Override
    public boolean remove(IEGLElement element) {
        this.removeAllChildren(element);
        return this.fRootElements.remove(element);
    }

    private void removeAllChildren(IEGLElement element) {
        if (element instanceof IParent) {
            ArrayList<IEGLElement> newRootElements = new ArrayList<IEGLElement>();
            int i = 0;
            int size = this.fRootElements.size();
            while (i < size) {
                IEGLElement currentRoot = (IEGLElement)this.fRootElements.get(i);
                IEGLElement parent = currentRoot.getParent();
                boolean isChild = false;
                while (parent != null) {
                    if (parent.equals(element)) {
                        isChild = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!isChild) {
                    newRootElements.add(currentRoot);
                }
                ++i;
            }
            this.fRootElements = newRootElements;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        IEGLElement[] roots = this.getElements();
        buffer.append('[');
        int i = 0;
        while (i < roots.length) {
            buffer.append(roots[i].getElementName());
            if (i < roots.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

