/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.jtopen.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.eglx.jtopen.messages.IBMiResourceKeys;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class AbstractStructParameterAnnotationValidator
implements IAnnotationValidationRule {
    private String annotationPackage = "eglx.jtopen.annotations.";
    protected IProblemRequestor problemRequestor;
    protected ICompilerOptions compilerOptions;

    protected abstract Type getSupportedType();

    public void validate(Node errorNode, Node target, Element targetBinding, Map<String, Object> allAnnotationsAndFields, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (targetBinding instanceof Field || targetBinding instanceof FunctionParameter || targetBinding instanceof Type) {
            Annotation annotation = targetBinding.getAnnotation(String.valueOf(this.annotationPackage) + this.getName());
            if (annotation == null) {
                annotation = (Annotation)allAnnotationsAndFields.get(NameUtile.getAsName((String)(String.valueOf(this.annotationPackage) + this.getName())));
            }
            if (annotation == null) {
                return;
            }
            this.compilerOptions = compilerOptions;
            this.problemRequestor = problemRequestor;
            if (targetBinding instanceof Field || targetBinding instanceof FunctionParameter) {
                this.validateMember(annotation, target, (Member)targetBinding);
                this.validateType(annotation, errorNode, target, ((Member)targetBinding).getType());
            } else if (targetBinding instanceof Type) {
                this.validateType(annotation, errorNode, target, (Type)targetBinding);
            }
        }
    }

    protected void validateMember(Annotation annotation, Node errorNode, Member member) {
        if (member.isNullable()) {
            this.problemRequestor.acceptProblem(errorNode, 5716, 2, new String[]{this.getName(), member.getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    protected void validateType(Annotation annotation, Node errorNode, Node target, Type type) {
        if (!this.isValidType(type)) {
            this.problemRequestor.acceptProblem(errorNode, 5700, 2, new String[]{this.getName(), BindingUtil.getShortTypeString((Type)type, (boolean)true)}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    protected abstract String getName();

    protected String getInternedName() {
        return NameUtile.getAsName((String)this.getName());
    }

    protected boolean isValidType(Type typeBinding) {
        if (typeBinding != null && this.getSupportedType() != null && typeBinding.getClassifier() instanceof EGLClass) {
            return this.getSupportedType().equals((Type)typeBinding.getClassifier());
        }
        return true;
    }
}

