/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.jtopen.validation.annotation;

import java.util.HashMap;
import org.eclipse.edt.compiler.binding.AnnotationValidationRule;
import org.eclipse.edt.compiler.binding.IValidationProxy;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.jtopen.ext.Utils;
import org.eclipse.edt.mof.eglx.jtopen.messages.IBMiResourceKeys;
import org.eclipse.edt.mof.eglx.jtopen.validation.annotation.AbstractStructParameterAnnotationValidator;
import org.eclipse.edt.mof.utils.NameUtile;

public class StructArrayValidator
extends AbstractStructParameterAnnotationValidator {
    @Override
    protected void validateType(Annotation annotation, Node errorNode, Node target, Type type) {
        super.validateType(annotation, errorNode, target, type);
        if (type != null && this.isValidType(type)) {
            this.validateElementTypeNotNullable(type, errorNode, target);
            if (annotation.getValue("elementTypeAnnotation") instanceof Annotation) {
                this.validateElementType((Annotation)annotation.getValue("elementTypeAnnotation"), type, errorNode, target);
            } else {
                this.validateElementTypeNotRequired(type, errorNode, target);
            }
            this.validateReturnCount(annotation, errorNode, target);
        }
    }

    private boolean isCompatibleWithINT(Type type) {
        Type _int = IRUtils.getEGLType((String)"egl:eglx.lang.EInt");
        return TypeUtils.areCompatible((Classifier)_int.getClassifier(), (NamedElement)type.getClassifier());
    }

    private void validateReturnCount(Annotation ann, Node errorNode, Node target) {
        Object obj = ann.getValue("returnCountVariable");
        if (obj == null || !(obj instanceof Member)) {
            return;
        }
        if (!this.isCompatibleWithINT(((Member)obj).getType())) {
            this.problemRequestor.acceptProblem(errorNode, 5713, 2, new String[]{((Member)obj).getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
        if (obj instanceof FunctionParameter) {
            return;
        }
        Type containerBinding = this.getContainerBinding(errorNode);
        if (((Member)obj).getContainer().equals(containerBinding)) {
            return;
        }
        this.problemRequestor.acceptProblem(errorNode, 5714, 2, new String[]{((Member)obj).getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
    }

    private Type getContainerBinding(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Part) {
            return ((Part)node).getName().resolveType();
        }
        return this.getContainerBinding(node.getParent());
    }

    private void validateElementTypeNotNullable(Type type, Node errorNode, Node target) {
        if (type instanceof ArrayType && ((ArrayType)type).elementsNullable()) {
            this.problemRequestor.acceptProblem(target, 5716, 2, new String[]{this.getName(), BindingUtil.getShortTypeString((Type)type, (boolean)true)}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    private void validateElementTypeNotRequired(Type type, Node errorNode, Node target) {
        if (type instanceof ArrayType && Utils.requiresAS400TypeAnnotation(((ArrayType)type).getElementType())) {
            this.problemRequestor.acceptProblem(target, 5710, 2, new String[]{"elementTypeAnnotation", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    private void validateElementType(Annotation ann, Type type, Node errorNode, Node target) {
        boolean hasStructTypeAnnotation = false;
        IValidationProxy proxy = AnnotationValidator.getValidationProxy((Annotation)ann);
        if (proxy != null) {
            for (AnnotationValidationRule rule : proxy.getAnnotationValidators()) {
                hasStructTypeAnnotation = true;
                HashMap<String, Annotation> annotations = new HashMap<String, Annotation>(1);
                annotations.put(NameUtile.getAsName((String)ann.getEClass().getETypeSignature()), ann);
                rule.validate(errorNode, errorNode, (Element)((ArrayType)type).getElementType(), annotations, this.problemRequestor, this.compilerOptions);
            }
        }
        if (!hasStructTypeAnnotation && Utils.requiresAS400TypeAnnotation(type)) {
            this.problemRequestor.acceptProblem(errorNode, 5715, 2, new String[]{BindingUtil.getShortTypeString((Type)type, (boolean)true)}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    @Override
    protected Type getSupportedType() {
        return null;
    }

    @Override
    protected String getName() {
        return "StructArray";
    }

    @Override
    protected boolean isValidType(Type typeBinding) {
        if (typeBinding != null) {
            if (typeBinding instanceof ArrayType) {
                return Utils.isValidAS400Type(typeBinding);
            }
            return false;
        }
        return true;
    }
}

