/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.jtopen.validation.annotation;

import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.jtopen.messages.IBMiResourceKeys;
import org.eclipse.edt.mof.eglx.jtopen.validation.annotation.AbstractStructParameterAnnotationValidator;

public class StructTextValidator
extends AbstractStructParameterAnnotationValidator {
    @Override
    protected void validateType(Annotation annotation, Node errorNode, Node target, Type type) {
        super.validateType(annotation, errorNode, target, type);
        if (type != null && this.isValidType(type)) {
            if (type instanceof SequenceType) {
                this.validateLengthNotSpecified(annotation, errorNode, target);
            } else {
                this.validateLengthSpecified(annotation, errorNode, target);
                this.validateLength(annotation, errorNode, target);
            }
        }
    }

    private void validateLength(Annotation ann, Node errorNode, Node target) {
        Integer length = (Integer)ann.getValue("length");
        if (length != null && (length < 1 || length > Integer.MAX_VALUE)) {
            this.problemRequestor.acceptProblem(errorNode, 5707, 2, new String[]{length.toString(), this.getName(), Integer.toString(Integer.MAX_VALUE)}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    protected void validateLengthNotSpecified(Annotation ann, Node errorNode, Node target) {
        if (ann.getValue("length") != null) {
            this.problemRequestor.acceptProblem(errorNode, 5711, 2, new String[]{"length", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    protected void validateLengthSpecified(Annotation ann, Node errorNode, Node target) {
        if (ann.getValue("length") == null) {
            this.problemRequestor.acceptProblem(errorNode, 5710, 2, new String[]{"length", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    @Override
    protected Type getSupportedType() {
        return TypeUtils.Type_STRING;
    }

    @Override
    protected String getName() {
        return "StructText";
    }
}

