/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.core.util.ILRUCacheable;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;

public class UseScanReferences
implements ILRUCacheable,
IReferenceCollection {
    Map fReferencesMap = new HashMap();

    public void add(String type, IReferenceDescriptor refDesc) {
        ArrayList<IReferenceDescriptor> refDescList = (ArrayList<IReferenceDescriptor>)this.fReferencesMap.get(type);
        if (refDescList == null) {
            refDescList = new ArrayList<IReferenceDescriptor>();
            this.fReferencesMap.put(type, refDescList);
        }
        if (!refDescList.contains(refDesc)) {
            refDescList.add(refDesc);
        }
    }

    public boolean hasReferencesTo(String type) {
        List refDescList = (List)this.fReferencesMap.get(type);
        return refDescList != null && refDescList.size() != 0;
    }

    public IReferenceDescriptor[] getExternalDependenciesTo(String[] types) {
        if (types == null || types.length == 0) {
            return new IReferenceDescriptor[0];
        }
        ArrayList referenceDescriptorList = new ArrayList();
        int i = 0;
        while (i < types.length) {
            List refDescs = (List)this.fReferencesMap.get(types[i]);
            if (refDescs != null && refDescs.size() != 0) {
                referenceDescriptorList.addAll(refDescs);
            }
            ++i;
        }
        return referenceDescriptorList.toArray(new IReferenceDescriptor[referenceDescriptorList.size()]);
    }

    public IReferenceDescriptor[] getAllExternalDependencies() {
        ArrayList allRefDescs = new ArrayList();
        Iterator iterator = this.fReferencesMap.values().iterator();
        while (iterator.hasNext()) {
            List refDescList = (List)iterator.next();
            allRefDescs.addAll(refDescList);
        }
        return allRefDescs.toArray(new IReferenceDescriptor[allRefDescs.size()]);
    }

    public int getCacheFootprint() {
        return this.fReferencesMap.size();
    }

    public void clear() {
        this.fReferencesMap.clear();
    }
}

