/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.edt.debug.ui.launching.EGLJavaLaunchUtils;
import org.eclipse.edt.debug.ui.launching.EGLLaunchingMessages;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.dialogs.PartSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class AbstractEGLApplicationTab
extends AbstractLaunchConfigurationTab {
    protected final ProjectLabelProvider projectLabelProvider = new ProjectLabelProvider();

    protected IEGLElement browseForPart(int partTypes, final String[] subTypes, String title, String message) {
        Object result;
        IEGLProject project = this.getEGLProject();
        IEGLElement[] elements = null;
        if (project == null || !project.exists()) {
            IEGLModel model = EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getEGLProjects();
                }
                catch (EGLModelException e) {
                    EDTDebugUIPlugin.log(e);
                }
            }
        } else {
            elements = new IEGLElement[]{project};
        }
        if (elements == null) {
            elements = new IEGLElement[]{};
        }
        PartSelectionDialog dialog = new PartSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), partTypes, null, SearchEngine.createEGLSearchScope((IEGLElement[])elements, (boolean)false)){

            protected int addParts(ArrayList partsList, IEGLSearchScope scope, int elementKinds, String subType) {
                int length;
                int n = length = subTypes == null ? 0 : subTypes.length;
                if (length < 2) {
                    return super.addParts(partsList, scope, elementKinds, length == 0 ? null : subTypes[0]);
                }
                HashSet allParts = new HashSet();
                String[] stringArray = subTypes;
                int n2 = subTypes.length;
                int n3 = 0;
                while (n3 < n2) {
                    ArrayList nextParts = new ArrayList();
                    String nextSubType = stringArray[n3];
                    if (super.addParts(nextParts, scope, elementKinds, nextSubType) == 1) {
                        return 1;
                    }
                    allParts.addAll(nextParts);
                    ++n3;
                }
                partsList.addAll(allParts);
                return 0;
            }
        };
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setMultipleSelection(false);
        dialog.setFilter("*");
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IEGLElement) {
            return (IEGLElement)result;
        }
        return null;
    }

    protected String browseForProject() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)this.projectLabelProvider);
        dialog.setTitle(EGLLaunchingMessages.egl_java_main_tab_project_browse_title);
        dialog.setMessage(EGLLaunchingMessages.egl_java_main_tab_project_browse_message);
        try {
            dialog.setElements((Object[])EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getEGLProjects());
        }
        catch (EGLModelException e) {
            EDTDebugUIPlugin.log(e);
        }
        IEGLProject eglProject = this.getEGLProject();
        if (eglProject != null) {
            dialog.setInitialSelections(new Object[]{eglProject});
        }
        if (dialog.open() == 0) {
            IEGLProject project = (IEGLProject)dialog.getFirstResult();
            if (project != null) {
                return project.getElementName();
            }
            return "";
        }
        return null;
    }

    protected IEGLProject getEGLProject() {
        String projectName = this.getProjectName();
        if (projectName == null) {
            return null;
        }
        if ((projectName = projectName.trim()).length() < 1) {
            return null;
        }
        return EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getEGLProject(projectName);
    }

    protected abstract String getProjectName();

    protected void initializeConfigName(IResource resource, ILaunchConfigurationWorkingCopy configuration) {
        ILaunchConfigurationDialog dialog;
        String configName = null;
        String name = resource.getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(0, index);
        }
        if ((dialog = this.getLaunchConfigurationDialog()) != null) {
            configName = this.getLaunchConfigurationDialog().generateName(name);
        }
        if (configName != null) {
            configuration.rename(configName);
        }
    }

    public Image getImage() {
        return EGLJavaLaunchUtils.getImage("IMG_LAUNCH_MAIN_TAB");
    }

    protected class ProjectLabelProvider
    extends LabelProvider {
        protected ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IEGLProject) {
                return ((IEGLProject)element).getElementName();
            }
            return super.getText(element);
        }
    }
}

