/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.debug.ui.launching.AbstractEGLApplicationTab;
import org.eclipse.edt.debug.ui.launching.EGLJavaLaunchUtils;
import org.eclipse.edt.debug.ui.launching.EGLLaunchingMessages;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EGLJavaMainApplicationTab
extends AbstractEGLApplicationTab
implements ModifyListener,
SelectionListener {
    protected Label fProjectLabel;
    protected Text fProjectText;
    protected Button fProjectBrowseButton;
    protected Label fProgramFileLabel;
    protected Text fProgramFileText;
    protected Button fProgramFileSearchButton;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createVerticalSpacer(composite, 1);
        Composite projectComposite = new Composite(composite, 0);
        GridLayout projectLayout = new GridLayout();
        projectLayout.numColumns = 2;
        projectLayout.marginHeight = 0;
        projectLayout.marginWidth = 0;
        projectComposite.setLayout((Layout)projectLayout);
        GridData gd = new GridData(768);
        projectComposite.setLayoutData((Object)gd);
        this.fProjectLabel = this.createLabel(projectComposite, EGLLaunchingMessages.egl_java_main_tab_project_label);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjectLabel.setLayoutData((Object)gd);
        this.fProjectText = this.createText(projectComposite);
        gd = new GridData(768);
        this.fProjectText.setLayoutData((Object)gd);
        this.fProjectText.addModifyListener((ModifyListener)this);
        this.fProjectBrowseButton = this.createPushButton(projectComposite, EGLLaunchingMessages.egl_java_main_tab_browse_button, null);
        this.fProjectBrowseButton.addSelectionListener((SelectionListener)this);
        this.createVerticalSpacer(composite, 1);
        Composite programFileComposite = new Composite(composite, 0);
        GridLayout programFileLayout = new GridLayout();
        programFileLayout.numColumns = 2;
        programFileLayout.marginHeight = 0;
        programFileLayout.marginWidth = 0;
        programFileComposite.setLayout((Layout)programFileLayout);
        gd = new GridData(768);
        programFileComposite.setLayoutData((Object)gd);
        this.fProgramFileLabel = this.createLabel(programFileComposite, EGLLaunchingMessages.egl_java_main_tab_program_file_label);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProgramFileLabel.setLayoutData((Object)gd);
        this.fProgramFileText = this.createText(programFileComposite);
        gd = new GridData(768);
        this.fProgramFileText.setLayoutData((Object)gd);
        this.fProgramFileText.addModifyListener((ModifyListener)this);
        this.fProgramFileSearchButton = this.createPushButton(programFileComposite, EGLLaunchingMessages.egl_java_main_tab_search_button, null);
        this.fProgramFileSearchButton.addSelectionListener((SelectionListener)this);
        this.fProgramFileSearchButton.setEnabled(false);
        this.createVerticalSpacer(composite, 1);
        Composite programComposite = new Composite(composite, 0);
        GridLayout programLayout = new GridLayout();
        programLayout.numColumns = 2;
        programLayout.marginHeight = 0;
        programLayout.marginWidth = 0;
        programComposite.setLayout((Layout)programLayout);
        gd = new GridData(768);
        programComposite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.edt.debug.ui.program_launch");
    }

    protected Label createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        return label;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setText("");
        text.addModifyListener((ModifyListener)this);
        text.setEnabled(true);
        return text;
    }

    protected Button createButton(Composite parent, int style, String label) {
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    protected void createVerticalSpacer(Composite parent, int numColumns) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
    }

    public void modifyText(ModifyEvent e) {
        this.updateLaunchConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.fProjectBrowseButton) {
            this.handleBrowseButtonPushed();
        } else if (e.getSource() == this.fProgramFileSearchButton) {
            this.handleProgramFileSearchButtonPushed();
        }
        this.updateLaunchConfigurationDialog();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.getSource() == this.fProjectBrowseButton) {
            this.handleBrowseButtonPushed();
        } else if (e.getSource() == this.fProgramFileSearchButton) {
            this.handleProgramFileSearchButtonPushed();
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleBrowseButtonPushed() {
        String project = this.browseForProject();
        if (project != null) {
            this.fProjectText.setText(project);
        }
    }

    @Override
    protected String getProjectName() {
        return this.fProjectText.getText();
    }

    protected void handleProgramFileSearchButtonPushed() {
        IEGLElement part = this.browseForPart(1, null, EGLLaunchingMessages.egl_java_main_tab_program_file_search_title, EGLLaunchingMessages.egl_java_main_tab_program_file_search_message);
        if (part != null) {
            this.fProgramFileText.setText(part.getResource().getProjectRelativePath().toString());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectNameFromConfig(configuration);
        this.updateProgramFileFromConfig(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.fProjectText.getText().trim();
        if (projectName.length() < 1) {
            this.setErrorMessage(EGLLaunchingMessages.egl_java_main_launch_configuration_no_project_specified);
            this.fProgramFileSearchButton.setEnabled(false);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            this.setErrorMessage(EGLLaunchingMessages.egl_java_main_launch_configuration_invalid_project);
            this.fProgramFileSearchButton.setEnabled(false);
            return false;
        }
        this.fProgramFileSearchButton.setEnabled(true);
        String programFileName = this.fProgramFileText.getText().trim();
        if (programFileName.length() < 1) {
            this.setErrorMessage(EGLLaunchingMessages.egl_java_main_launch_configuration_no_program_file_specified);
            return false;
        }
        if (!DebugUtil.isEGLFileName((String)programFileName)) {
            this.setErrorMessage(EGLLaunchingMessages.egl_java_main_launch_configuration_invalid_program_file);
            return false;
        }
        IFile file = project.getFile(programFileName);
        if (!file.exists()) {
            this.setErrorMessage(EGLLaunchingMessages.egl_java_main_tab_program_file_not_in_project);
            return false;
        }
        if (!this.isProgram((IResource)file)) {
            this.setErrorMessage(EGLLaunchingMessages.egl_java_main_launch_configuration_file_not_program);
            return false;
        }
        return true;
    }

    public void dispose() {
        this.fProjectLabel = null;
        this.fProjectText = null;
        this.fProjectBrowseButton = null;
        this.fProgramFileSearchButton = null;
        this.fProgramFileLabel = null;
        this.fProgramFileText = null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String projectName = this.fProjectText.getText().trim();
        configuration.setAttribute("org.eclipse.edt.debug.ui.attr_project_name", projectName);
        configuration.setAttribute("org.eclipse.edt.debug.ui.attr_program_file", this.fProgramFileText.getText().trim());
        EGLJavaLaunchUtils.addJavaAttributes(projectName, configuration);
    }

    private boolean isProgram(IResource resource) {
        IEGLFile file = (IEGLFile)EGLCore.create((IResource)resource);
        IPart part = file.getPart(new Path(resource.getName()).removeFileExtension().toString());
        return part != null && part.exists() && ((SourcePart)part).isProgram();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResource resource = DebugUtil.getContext();
        if (resource != null) {
            if (DebugUtil.isEGLFileName((String)resource.getName())) {
                this.initializeProject(resource, configuration);
                this.initializeConfigName(resource, configuration);
                if (this.isProgram(resource)) {
                    this.initializeProgramFile(resource, configuration);
                }
            } else {
                this.initializeProject(resource, configuration);
            }
        } else {
            configuration.setAttribute("org.eclipse.edt.debug.ui.attr_project_name", null);
        }
    }

    protected void initializeProgramFile(IResource resource, ILaunchConfigurationWorkingCopy configuration) {
        String pathStr = resource.getFullPath().toString();
        int index = pathStr.indexOf(47, 1);
        configuration.setAttribute("org.eclipse.edt.debug.ui.attr_program_file", pathStr.substring(index + 1));
    }

    protected void initializeProject(IResource resource, ILaunchConfigurationWorkingCopy configuration) {
        IProject project = resource.getProject();
        String name = null;
        if (project != null && project.exists()) {
            name = project.getName();
        }
        configuration.setAttribute("org.eclipse.edt.debug.ui.attr_project_name", name);
    }

    protected void updateProjectNameFromConfig(ILaunchConfiguration configuration) {
        try {
            this.fProjectText.setText(configuration.getAttribute("org.eclipse.edt.debug.ui.attr_project_name", ""));
        }
        catch (CoreException coreException) {
            this.fProjectText.setText("");
        }
    }

    protected void updateProgramFileFromConfig(ILaunchConfiguration configuration) {
        try {
            this.fProgramFileText.setText(configuration.getAttribute("org.eclipse.edt.debug.ui.attr_program_file", ""));
        }
        catch (CoreException coreException) {
            this.fProgramFileText.setText("");
        }
    }

    public String getName() {
        return EGLLaunchingMessages.egl_java_main_tab_name;
    }
}

