/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import java.util.ArrayList;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlGetByKeyStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;

public class SqlGetByKeyStatementImpl
extends SqlIOStatementImpl
implements SqlGetByKeyStatement {
    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    private String generateDefaultSqlString() {
        Expression target;
        boolean targetIsList;
        EGLClass targetType;
        if (this.getPreparedStatement() != null || Utils.isSQLResultSet(this.getDataSource().getType())) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        if (this.getTargets().size() == 1 && !TypeUtils.isDynamicType((Type)(targetType = (targetIsList = (target = (Expression)this.getTargets().get(0)).getType() instanceof ArrayType) ? (EGLClass)((ArrayType)target.getType()).getElementType().getClassifier() : (EGLClass)target.getType().getClassifier()))) {
            sql.append("SELECT ");
            ArrayList<Field> idFields = new ArrayList<Field>();
            boolean doComma = false;
            for (Field f : targetType.getFields()) {
                if (Utils.isKeyField(f)) {
                    idFields.add(f);
                }
                if (!Utils.isReadable(f)) continue;
                if (doComma) {
                    sql.append(", ");
                }
                if (Utils.isTextType(f.getType().getClassifier())) {
                    sql.append("RTRIM(");
                    sql.append(Utils.getColumnName(f));
                    sql.append(")");
                } else {
                    sql.append(Utils.getColumnName(f));
                }
                if (doComma) continue;
                doComma = true;
            }
            sql.append(" FROM ");
            sql.append(Utils.getTableName(targetType));
            if (!targetIsList && !idFields.isEmpty()) {
                sql.append(" WHERE ");
                boolean doAnd = false;
                for (Field f : idFields) {
                    if (doAnd) {
                        sql.append(" AND ");
                    }
                    sql.append(String.valueOf(Utils.getColumnName(f)) + " = ?");
                    if (doAnd) continue;
                    doAnd = true;
                }
            }
        }
        return sql.toString();
    }
}

