/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlReplaceStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;

public class SqlReplaceStatementImpl
extends SqlIOStatementImpl
implements SqlReplaceStatement {
    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    public String generateDefaultSqlString() {
        if (Utils.isSQLResultSet(this.getDataSource().getType())) {
            return null;
        }
        String sql = null;
        Expression target = (Expression)this.getTargets().get(0);
        boolean targetIsList = target.getType().getClassifier().equals(TypeUtils.Type_LIST);
        EGLClass targetType = targetIsList ? (EGLClass)((ArrayType)target.getType()).getElementType().getClassifier() : (EGLClass)target.getType().getClassifier();
        sql = "UPDATE ";
        sql = String.valueOf(sql) + Utils.getTableName(targetType);
        sql = String.valueOf(sql) + " SET ";
        boolean doComma = false;
        for (Field f : targetType.getFields()) {
            if (Utils.isKeyField(f) || !Utils.isUpdateable(f)) continue;
            if (doComma) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + Utils.getColumnName(f);
            sql = String.valueOf(sql) + " = ?";
            if (doComma) continue;
            doComma = true;
        }
        sql = String.valueOf(sql) + " WHERE ";
        boolean addAND = false;
        for (Field f : targetType.getFields()) {
            if (!Utils.isKeyField(f)) continue;
            if (addAND) {
                sql = String.valueOf(sql) + " AND ";
            }
            addAND = true;
            sql = String.valueOf(sql) + Utils.getColumnName(f);
            sql = String.valueOf(sql) + " = ?";
        }
        return sql;
    }
}

