/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.utils.NameUtile;

public class AbstractSqlStatementValidator {
    protected static final String OneToOne = NameUtile.getAsName((String)"eglx.persistence.OneToOne");
    protected static final String OneToMany = NameUtile.getAsName((String)"eglx.persistence.OneToMany");
    protected static final String ManyToOne = NameUtile.getAsName((String)"eglx.persistence.ManyToOne");
    protected static final String ManyToMany = NameUtile.getAsName((String)"eglx.persistence.ManyToMany");
    protected static final String Id = NameUtile.getAsName((String)"eglx.persistence.Id");
    protected static final String SecondaryTable = NameUtile.getAsName((String)"eglx.persistence.sql.SecondaryTable");
    protected static final String SecondaryTables = NameUtile.getAsName((String)"eglx.persistence.sql.SecondaryTables");

    protected boolean isEntity(Type type) {
        return type instanceof Record || type instanceof Handler || type instanceof ExternalType;
    }

    protected boolean isEntityWithID(Type type) {
        if (type == null || !this.isEntity(type)) {
            return false;
        }
        return this.hasID(type);
    }

    protected boolean hasID(Type type) {
        if (type == null) {
            return false;
        }
        ArrayList<Field> fields = null;
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getElementType();
        }
        if (type instanceof Record) {
            fields = ((Record)type).getFields();
        } else if (type instanceof Handler) {
            fields = ((Handler)type).getFields();
        } else if (type instanceof ExternalType) {
            List members = ((ExternalType)type).getAllMembers();
            fields = new ArrayList<Field>(members.size());
            for (Member m : members) {
                if (!(m instanceof Field)) continue;
                fields.add((Field)m);
            }
        }
        if (fields == null) {
            return false;
        }
        for (Field field : fields) {
            if (field.getAnnotation(Id) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isAssociationExpression(Expression exp) {
        Member data = exp.resolveMember();
        if (data == null) {
            return false;
        }
        if (!this.isEntity(this.getContainingType(data))) {
            return false;
        }
        Annotation annotation = data.getAnnotation(OneToOne);
        if (annotation == null) {
            annotation = data.getAnnotation(OneToMany);
        }
        if (annotation == null) {
            annotation = data.getAnnotation(ManyToOne);
        }
        if (annotation == null) {
            annotation = data.getAnnotation(ManyToMany);
        }
        return annotation != null;
    }

    protected Type getContainingType(Member m) {
        if (m == null) {
            return null;
        }
        Container container = m.getContainer();
        while (container instanceof Member && ((Member)container).getContainer() != null) {
            container = ((Member)container).getContainer();
        }
        if (container instanceof Type) {
            return (Type)container;
        }
        return null;
    }

    protected boolean isDataExpr(Expression expr) {
        Type type = expr.resolveType();
        if (type == null) {
            return false;
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return elementType != null && this.isEntity(elementType);
        }
        return this.isScalar(expr) || this.isEntity(type) || this.isAssociationExpression(expr);
    }

    protected boolean isScalar(Expression expr) {
        Type type = expr.resolveType();
        return type != null && TypeUtils.isPrimitive((Type)type);
    }

    protected boolean mapsToColumns(List exprs) {
        int size = exprs.size();
        int i = 0;
        while (i < size) {
            Node n = (Node)exprs.get(i);
            if (n instanceof Expression) {
                Expression expr = (Expression)n;
                if (!this.isScalar(expr)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean mapsToSingleTable(List<Expression> exprs) {
        Type firstParent = null;
        for (Expression e : exprs) {
            Member binding = e.resolveMember();
            if (binding == null) continue;
            Type parent = this.getContainingType(binding);
            if (parent == null) {
                return false;
            }
            if (firstParent == null) {
                firstParent = parent;
                continue;
            }
            if (firstParent.equals(parent).booleanValue()) continue;
            return false;
        }
        if (firstParent == null) {
            return false;
        }
        return this.isEntity(firstParent) && this.isSingleTable(firstParent);
    }

    protected int[] getOffsets(Collection<Node> nodes) {
        int startOffset = -1;
        int endOffset = -1;
        for (Node n : nodes) {
            int nextStart = n.getOffset();
            int nextEnd = nextStart + n.getLength();
            if (startOffset == -1 || nextStart < startOffset) {
                startOffset = nextStart;
            }
            if (endOffset != -1 && nextEnd <= endOffset) continue;
            endOffset = nextEnd;
        }
        return new int[]{startOffset, endOffset};
    }

    protected boolean isSingleTable(Type type) {
        Object value;
        if (type == null) {
            return false;
        }
        if (type.getAnnotation(SecondaryTable) != null) {
            return false;
        }
        Annotation annot = type.getAnnotation(SecondaryTables);
        if (annot != null && (value = annot.getValue()) instanceof Object[]) {
            return ((Object[])value).length == 0;
        }
        return true;
    }
}

