/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class GetByKeyStatementValidator
extends AbstractSqlStatementValidator {
    GetByKeyStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    UsingClause using;
    UsingKeysClause usingKeys;
    FromOrToExpressionClause from;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    IntoClause into;

    public GetByKeyStatementValidator(GetByKeyStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTargets();
        this.validateFrom();
        this.validateInto();
    }

    private void validateTargets() {
        Type targetType;
        int[] offsets;
        Expression expr;
        Object o;
        boolean isDataExpr = false;
        List targets = this.statement.getTargets();
        if (targets.size() == 1 && (o = targets.get(0)) instanceof Expression && this.isDataExpr(expr = (Expression)o)) {
            if (this.isAssociationExpression(expr)) {
                this.problemRequestor.acceptProblem((Node)expr, 8508, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (expr.resolveElement() instanceof TypedElement && ((TypedElement)expr.resolveElement()).isNullable() && this.isEntity(expr.resolveType()) && !TypeValidator.hasPublicDefaultConstructor((Type)expr.resolveType())) {
                this.problemRequestor.acceptProblem((Node)expr, 8519, 2, new String[]{expr.getCanonicalString(), expr.resolveType().getTypeSignature()}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            isDataExpr = true;
        }
        if (!isDataExpr && !this.mapsToColumns(targets)) {
            offsets = this.getOffsets(targets);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8505, true, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        if (!(isDataExpr || this.withExpression != null || this.withInline != null || this.mapsToSingleTable(targets) || this.isFromResultSet())) {
            offsets = this.getOffsets(targets);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8518, true, new String[]{"with"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        if (this.using == null && this.withExpression == null && this.withInline == null && (targetType = this.getTargetType(isDataExpr)) != null && !this.hasID(targetType)) {
            int[] offsets2 = this.getOffsets(targets);
            this.problemRequestor.acceptProblem(offsets2[0], offsets2[1], 8509, true, new String[]{targetType.getTypeSignature()}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private Type getTargetType(boolean isDataExpr) {
        Expression e;
        Type type = null;
        List targets = this.statement.getTargets();
        if ((isDataExpr || this.mapsToSingleTable(targets)) && (type = (e = (Expression)targets.get(0)).resolveType()) != null && TypeUtils.isPrimitive((Type)type)) {
            type = this.getContainingType(e.resolveMember());
        }
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getElementType();
        }
        return type;
    }

    private boolean isFromResultSet() {
        if (this.from != null) {
            return Utils.isSQLResultSet(this.from.getExpression().resolveType());
        }
        return false;
    }

    private void validateFrom() {
        Type type;
        if (!(this.from == null || this.withExpression == null && this.withInline == null || (type = this.from.getExpression().resolveType()) == null || Utils.isSQLDataSource(type))) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, 2, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLDataSource"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateInto() {
        if (this.into != null) {
            this.problemRequestor.acceptProblem((Node)this.into, 8504, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (GetByKeyStatementValidator.this.withInline == null && GetByKeyStatementValidator.this.withExpression == null) {
                    GetByKeyStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"get".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithExpressionClause withExpressionClause) {
                if (GetByKeyStatementValidator.this.withInline == null && GetByKeyStatementValidator.this.withExpression == null) {
                    GetByKeyStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"get".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingClause usingClause) {
                if (GetByKeyStatementValidator.this.using == null) {
                    GetByKeyStatementValidator.this.using = usingClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"get".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingKeysClause usingKeysClause) {
                if (GetByKeyStatementValidator.this.usingKeys == null) {
                    GetByKeyStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"get".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (GetByKeyStatementValidator.this.from == null) {
                    GetByKeyStatementValidator.this.from = clause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"get".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }

            public boolean visit(IntoClause intoClause) {
                if (GetByKeyStatementValidator.this.into == null) {
                    GetByKeyStatementValidator.this.into = intoClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)intoClause, 6510, new String[]{"get".toUpperCase(), "into".toUpperCase()});
                }
                return false;
            }
        });
    }
}

