/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class OpenStatementValidator
extends AbstractSqlStatementValidator {
    OpenStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    ForUpdateClause forUpdate;
    IntoClause into;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    UsingClause using;
    UsingKeysClause usingKeys;
    ForExpressionClause forExpression;
    FromOrToExpressionClause from;

    public OpenStatementValidator(OpenStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFrom();
        this.validateWith();
        this.validateFor();
        this.validateInto();
    }

    private void validateTarget() {
        Type targetType = this.statement.getResultSet().resolveType();
        if (targetType != null && !Utils.isSQLResultSet(targetType)) {
            this.problemRequestor.acceptProblem((Node)this.statement.getResultSet(), 8500, 2, new String[]{this.statement.getResultSet().getCanonicalString(), "eglx.persistence.sql.SQLResultSet"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateFrom() {
        Type type;
        if (this.from != null && (type = this.from.getExpression().resolveType()) != null && !Utils.isSQLDataSource(type)) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, 2, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLDataSource"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateWith() {
        boolean isSqlStatement = false;
        if (this.withExpression != null) {
            Type type = this.withExpression.getExpression().resolveType();
            if (type != null && !Utils.isSQLStatement(type)) {
                this.problemRequestor.acceptProblem((Node)this.withExpression.getExpression(), 8500, 2, new String[]{this.withExpression.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLStatement"}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            isSqlStatement = true;
        }
        if (this.from == null && !isSqlStatement) {
            this.problemRequestor.acceptProblem((Node)this.statement, 8501, 2, new String[]{"eglx.persistence.sql.SQLStatement"}, SQLResourceKeys.getResourceBundleForKeys());
        }
    }

    private void validateFor() {
        if (this.forExpression != null) {
            if (this.withExpression != null || this.withInline != null) {
                this.problemRequestor.acceptProblem((Node)this.forExpression, 8503, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
            Type type = this.forExpression.getExpression().resolveType();
            if (type != null && (!this.isEntityWithID(type) || this.isAssociationExpression(this.forExpression.getExpression()))) {
                this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8502, 2, new String[]{this.forExpression.getExpression().getCanonicalString()}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void validateInto() {
        if (this.into != null) {
            this.problemRequestor.acceptProblem((Node)this.into, 8504, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(ForUpdateClause forUpdateClause) {
                if (OpenStatementValidator.this.forUpdate == null) {
                    OpenStatementValidator.this.forUpdate = forUpdateClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)forUpdateClause, 6510, new String[]{"open".toUpperCase(), "forUpdate".toUpperCase()});
                }
                return false;
            }

            public boolean visit(IntoClause intoClause) {
                if (OpenStatementValidator.this.into == null) {
                    OpenStatementValidator.this.into = intoClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)intoClause, 6510, new String[]{"open".toUpperCase(), "into".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (OpenStatementValidator.this.withInline == null && OpenStatementValidator.this.withExpression == null) {
                    OpenStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"open".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithExpressionClause withExpressionClause) {
                if (OpenStatementValidator.this.withInline == null && OpenStatementValidator.this.withExpression == null) {
                    OpenStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"open".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingClause usingClause) {
                if (OpenStatementValidator.this.using == null) {
                    OpenStatementValidator.this.using = usingClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"open".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingKeysClause usingKeysClause) {
                if (OpenStatementValidator.this.usingKeys == null) {
                    OpenStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"open".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            public boolean visit(ForExpressionClause forExpressionClause) {
                if (OpenStatementValidator.this.forExpression == null) {
                    OpenStatementValidator.this.forExpression = forExpressionClause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"open".toUpperCase(), "for".toUpperCase()});
                }
                return false;
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (OpenStatementValidator.this.from == null) {
                    OpenStatementValidator.this.from = clause;
                } else {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"open".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }
        });
    }
}

