/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.filters;

import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.filters.AbstractTypeFilter;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JDTStepFilter
extends AbstractTypeFilter
implements IPropertyChangeListener {
    private String[] packageFilters;
    private Map<String, Object> classFilters;
    private static final java.lang.reflect.Method isFilterGetters;
    private static final java.lang.reflect.Method isFilterSetters;
    private static final java.lang.reflect.Method isGetterMethod;
    private static final java.lang.reflect.Method isSetterMethod;
    private static final java.lang.reflect.Method setFilterGetters;
    private static final java.lang.reflect.Method setFilterSetters;
    private static final String PREF_FILTER_GETTERS;
    private static final String PREF_FILTER_SETTERS;

    static {
        PREF_FILTER_GETTERS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".filter_get";
        PREF_FILTER_SETTERS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".filter_setters";
        java.lang.reflect.Method filterGetters = null;
        java.lang.reflect.Method filterSetters = null;
        java.lang.reflect.Method getterMethod = null;
        java.lang.reflect.Method setterMethod = null;
        java.lang.reflect.Method setGetters = null;
        java.lang.reflect.Method setSetters = null;
        try {
            filterGetters = IJavaDebugTarget.class.getMethod("isFilterGetters", null);
            filterSetters = IJavaDebugTarget.class.getMethod("isFilterSetters", null);
            setGetters = IJavaDebugTarget.class.getMethod("setFilterGetters", Boolean.TYPE);
            setSetters = IJavaDebugTarget.class.getMethod("setFilterSetters", Boolean.TYPE);
            Class<?> JDIMethodClass = Class.forName("org.eclipse.jdt.internal.debug.core.model.JDIMethod");
            getterMethod = JDIMethodClass.getMethod("isGetterMethod", Method.class);
            setterMethod = JDIMethodClass.getMethod("isSetterMethod", Method.class);
        }
        catch (Throwable throwable) {}
        isFilterGetters = filterGetters;
        isFilterSetters = filterSetters;
        isGetterMethod = getterMethod;
        isSetterMethod = setterMethod;
        setFilterGetters = setGetters;
        setFilterSetters = setSetters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean filter(IJavaStackFrame frame, IEGLJavaDebugTarget target) {
        if (!target.isStepFiltersEnabled()) {
            return false;
        }
        IJavaDebugTarget javaTarget = target.getJavaDebugTarget();
        if (this.filterConstructor(frame, javaTarget) || this.filterStaticInitializer(frame, javaTarget) || this.filterSynthetic(frame, javaTarget) || this.filterGetter(frame, javaTarget) || this.filterSetter(frame, javaTarget)) {
            return true;
        }
        try {
            String typeName = frame.getReferenceType().getName();
            if (this.classFilters.containsKey(typeName)) {
                return true;
            }
            String[] stringArray = this.packageFilters;
            int n = this.packageFilters.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String filter = stringArray[n2];
                if (typeName.startsWith(filter)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    @Override
    public void initialize(IEGLJavaDebugTarget target) {
        this.initActiveFilters();
    }

    private String[] initActiveFilters() {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        if (this.classFilters == null) {
            this.classFilters = new HashMap<String, Object>(50);
            store.addPropertyChangeListener((IPropertyChangeListener)this);
        } else {
            this.classFilters.clear();
        }
        String[] allFilters = JavaDebugOptionsManager.parseList((String)store.getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
        ArrayList<String> pkgFilters = new ArrayList<String>();
        String[] stringArray = allFilters;
        int n = allFilters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            int len = filter.length();
            if (len > 0 && filter.charAt(len - 1) == '*') {
                pkgFilters.add(filter.substring(0, len - 1));
            } else {
                this.classFilters.put(filter, null);
            }
            ++n2;
        }
        this.packageFilters = pkgFilters.toArray(new String[pkgFilters.size()]);
        return allFilters;
    }

    private boolean filterConstructor(IJavaStackFrame frame, IJavaDebugTarget target) {
        if (target.isFilterConstructors()) {
            try {
                return frame.isConstructor();
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    private boolean filterStaticInitializer(IJavaStackFrame frame, IJavaDebugTarget target) {
        if (target.isFilterStaticInitializers()) {
            try {
                return frame.isStaticInitializer();
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    private boolean filterSynthetic(IJavaStackFrame frame, IJavaDebugTarget target) {
        if (target.isFilterSynthetics()) {
            try {
                return frame.isSynthetic();
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    private boolean filterGetter(IJavaStackFrame frame, IJavaDebugTarget target) {
        if (isFilterGetters != null) {
            try {
                if (((Boolean)isFilterGetters.invoke((Object)target, null)).booleanValue()) {
                    if (isGetterMethod != null && frame instanceof JDIStackFrame) {
                        return (Boolean)isGetterMethod.invoke(null, ((JDIStackFrame)frame).getUnderlyingMethod());
                    }
                    String method = frame.getMethodName();
                    return method.startsWith("get") || method.startsWith("is");
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private boolean filterSetter(IJavaStackFrame frame, IJavaDebugTarget target) {
        if (isFilterSetters != null) {
            try {
                if (((Boolean)isFilterSetters.invoke((Object)target, null)).booleanValue()) {
                    if (isSetterMethod != null && frame instanceof JDIStackFrame) {
                        return (Boolean)isSetterMethod.invoke(null, ((JDIStackFrame)frame).getUnderlyingMethod());
                    }
                    String method = frame.getMethodName();
                    return method.startsWith("set");
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        JDIDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        IEGLJavaDebugTarget eglTarget;
        IDebugTarget target;
        int n;
        int n2;
        IDebugTarget[] iDebugTargetArray;
        boolean refreshFrames = false;
        String property = event.getProperty();
        if (IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS.equals(property)) {
            boolean filterConstructors = JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS);
            refreshFrames = true;
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null) {
                    eglTarget.getJavaDebugTarget().setFilterConstructors(filterConstructors);
                }
                ++n;
            }
        } else if (IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS.equals(property)) {
            boolean filterStaticInitializers = JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS);
            refreshFrames = true;
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null) {
                    eglTarget.getJavaDebugTarget().setFilterStaticInitializers(filterStaticInitializers);
                }
                ++n;
            }
        } else if (PREF_FILTER_GETTERS.equals(property)) {
            boolean filterGetters = JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_FILTER_GETTERS);
            refreshFrames = true;
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null && setFilterGetters != null) {
                    try {
                        setFilterGetters.invoke((Object)eglTarget.getJavaDebugTarget(), filterGetters);
                    }
                    catch (Exception e) {
                        EDTDebugCorePlugin.log(e);
                    }
                }
                ++n;
            }
        } else if (PREF_FILTER_SETTERS.equals(property)) {
            boolean filterSetters = JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_FILTER_SETTERS);
            refreshFrames = true;
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null && setFilterSetters != null) {
                    try {
                        setFilterSetters.invoke((Object)eglTarget.getJavaDebugTarget(), filterSetters);
                    }
                    catch (Exception e) {
                        EDTDebugCorePlugin.log(e);
                    }
                }
                ++n;
            }
        } else if (IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS.equals(property)) {
            boolean filterSynthetics = JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS);
            refreshFrames = true;
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null) {
                    eglTarget.getJavaDebugTarget().setFilterSynthetics(filterSynthetics);
                }
                ++n;
            }
        } else if (IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST.equals(property)) {
            String[] allFilters = this.initActiveFilters();
            refreshFrames = true;
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null) {
                    eglTarget.getJavaDebugTarget().setStepFilters(allFilters);
                }
                ++n;
            }
        } else if (IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS.equals(property)) {
            boolean stepThru = JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS);
            iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n2 = iDebugTargetArray.length;
            n = 0;
            while (n < n2) {
                target = iDebugTargetArray[n];
                eglTarget = (IEGLJavaDebugTarget)target.getAdapter(IEGLJavaDebugTarget.class);
                if (eglTarget != null) {
                    eglTarget.getJavaDebugTarget().setStepThruFilters(stepThru);
                }
                ++n;
            }
        }
        if (refreshFrames) {
            IDebugTarget[] iDebugTargetArray2 = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            n = iDebugTargetArray2.length;
            int n3 = 0;
            while (n3 < n) {
                IDebugTarget target2 = iDebugTargetArray2[n3];
                EGLJavaDebugTarget eglTarget2 = (EGLJavaDebugTarget)target2.getAdapter(EGLJavaDebugTarget.class);
                if (eglTarget2 != null) {
                    eglTarget2.refreshAllFrames();
                }
                ++n3;
            }
        }
    }
}

