/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.impl;

import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.NoSuchFunctionError;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.impl.ExpressionImpl;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ArrayAccessImpl
extends ExpressionImpl
implements ArrayAccess {
    private static int Slot_array = 0;
    private static int Slot_index = 1;
    private static int Slot_operation = 2;
    private static int totalSlots = 3;

    static {
        int offset = ExpressionImpl.totalSlots();
        Slot_array += offset;
        Slot_index += offset;
        Slot_operation += offset;
    }

    public static int totalSlots() {
        return totalSlots + ExpressionImpl.totalSlots();
    }

    @Override
    public Expression getArray() {
        return (Expression)this.slotGet(Slot_array);
    }

    @Override
    public void setArray(Expression value) {
        this.slotSet(Slot_array, value);
    }

    @Override
    public Expression getIndex() {
        return (Expression)this.slotGet(Slot_index);
    }

    @Override
    public void setIndex(Expression value) {
        this.slotSet(Slot_index, value);
    }

    @Override
    public Type getType() {
        Type arrayType = this.getArray().getType();
        if (arrayType instanceof GenericType && !((GenericType)arrayType).getTypeArguments().isEmpty()) {
            return ((GenericType)arrayType).getTypeArguments().get(0);
        }
        return TypeUtils.Type_ANY;
    }

    @Override
    public boolean isNullable() {
        if (this.getArray().getType() instanceof ArrayType) {
            return ((ArrayType)this.getArray().getType()).elementsNullable();
        }
        return false;
    }

    @Override
    public Operation getOperation() {
        if (this.slotGet(Slot_operation) == null) {
            try {
                this.setOperation(this.resolveOperation());
            }
            catch (NoSuchFunctionError e) {
                throw new RuntimeException(e);
            }
        }
        return (Operation)this.slotGet(Slot_operation);
    }

    @Override
    public void setOperation(Operation value) {
        this.slotSet(Slot_operation, value);
    }

    private Operation resolveOperation() {
        Operation op = IRUtils.getMyOperation(this.getArray().getType().getClassifier(), "[]");
        if (op == null) {
            throw new NoSuchFunctionError();
        }
        return op;
    }

    @Override
    public ArrayAccess addQualifier(Expression expr) {
        ArrayAccess newAA = IrFactory.INSTANCE.createArrayAccess();
        newAA.setIndex(this.getIndex());
        newAA.setArray(this.getArray());
        newAA.getAnnotations().addAll(this.getAnnotations());
        if (this.getArray() instanceof LHSExpr) {
            newAA.setArray(((LHSExpr)this.getArray()).addQualifier(expr));
        } else if (this.getArray() instanceof InvocationExpression) {
            newAA.setArray(((InvocationExpression)this.getArray()).addQualifier(expr));
        } else if (this.getArray() instanceof ThisExpression) {
            newAA.setArray(expr);
        }
        return newAA;
    }
}

