/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.impl;

import java.util.List;
import org.eclipse.edt.mof.egl.AmbiguousFunctionReferenceError;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.NoSuchFunctionError;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.impl.InvocationExpressionImpl;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class QualifiedFunctionInvocationImpl
extends InvocationExpressionImpl
implements QualifiedFunctionInvocation {
    private static int Slot_target = 0;
    private static int Slot_qualifier = 1;
    private static int totalSlots = 2;

    static {
        int offset = InvocationExpressionImpl.totalSlots();
        Slot_target += offset;
        Slot_qualifier += offset;
    }

    public static int totalSlots() {
        return totalSlots + InvocationExpressionImpl.totalSlots();
    }

    @Override
    public FunctionMember getTarget() {
        if (this.slotGet(Slot_target) == null) {
            try {
                this.setTarget(this.resolveFunction());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (FunctionMember)this.slotGet(Slot_target);
    }

    @Override
    public void setTarget(FunctionMember value) {
        this.slotSet(Slot_target, value);
    }

    @Override
    public Expression getQualifier() {
        return (Expression)this.slotGet(Slot_qualifier);
    }

    @Override
    public void setQualifier(Expression value) {
        this.slotSet(Slot_qualifier, value);
    }

    @Override
    public QualifiedFunctionInvocation addQualifier(Expression expr) {
        QualifiedFunctionInvocation newInv = IrFactory.INSTANCE.createQualifiedFunctionInvocation();
        newInv.setId(this.getId());
        newInv.getArguments().addAll(this.getArguments());
        newInv.setQualifier(this.getQualifier());
        newInv.getAnnotations().addAll(this.getAnnotations());
        if (this.getQualifier() instanceof LHSExpr) {
            newInv.setQualifier(((LHSExpr)this.getQualifier()).addQualifier(expr));
        } else if (this.getQualifier() instanceof InvocationExpression) {
            newInv.setQualifier(((InvocationExpression)this.getQualifier()).addQualifier(expr));
        } else if (this.getQualifier() instanceof ThisExpression) {
            newInv.setQualifier(expr);
        }
        return newInv;
    }

    @Override
    public Type getType() {
        Type type = this.getTarget().getType();
        if (type instanceof GenericType && type.getClassifier() == null) {
            type = ((GenericType)type).resolveTypeParameter(this.getQualifier().getType());
        }
        return type;
    }

    @Override
    public Type getParameterTypeForArg(int index) {
        Type type = super.getParameterTypeForArg(index);
        if (type instanceof GenericType && type.getClassifier() == null) {
            type = ((GenericType)type).resolveTypeParameter(this.getQualifier().getType());
        } else if (type instanceof ArrayType && ((ArrayType)type).getElementType() instanceof GenericType && ((ArrayType)type).getElementType().getClassifier() == null) {
            return this.getQualifier().getType();
        }
        return type;
    }

    private Function resolveFunction() {
        StructPart container = (StructPart)this.getQualifier().getType().getClassifier();
        NamedElement[] argTypes = new NamedElement[this.getArguments().size()];
        int i = 0;
        for (Expression expr : this.getArguments()) {
            argTypes[i] = expr instanceof Name && ((Name)expr).getNamedElement() instanceof Function ? (Function)((Name)expr).getNamedElement() : expr.getType().getClassifier();
            ++i;
        }
        List<Function> result = null;
        result = TypeUtils.getBestFitFunction(container, this.getId(), argTypes);
        if (result.isEmpty()) {
            throw new NoSuchFunctionError();
        }
        if (result.size() > 1) {
            throw new AmbiguousFunctionReferenceError();
        }
        return result.get(0);
    }

    @Override
    public boolean isNullable() {
        return this.getTarget().isNullable();
    }
}

