/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.AmbiguousReferenceException;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DanglingReference;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.FunctionPartInvocation;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.NewExpression;
import org.eclipse.edt.mof.egl.NullLiteral;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PatternType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.StructuredContainer;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.SubType;
import org.eclipse.edt.mof.egl.TernaryExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeName;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.EList;

public class IRUtils {
    private static IrFactory factory = IrFactory.INSTANCE;
    public static String OVERLOADED_FUNCTION = "EZE_OVERLOADED_FUNCTION";
    private static String EGL_SCHEMA = "egl:";

    public static MofSerializable getType(String typeSignature) {
        try {
            return (MofSerializable)Environment.getCurrentEnv().find(typeSignature);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Type getEGLType(String typeSignature) {
        String mofKey = typeSignature;
        if (!typeSignature.startsWith("egl:")) {
            mofKey = "egl:" + mofKey;
        }
        return (Type)IRUtils.getType(mofKey);
    }

    public static Type getEGLType(String primSignature, int length, int decimals) {
        String sig = String.valueOf(primSignature) + "(" + length + ":" + decimals + ")";
        return IRUtils.getEGLType(sig);
    }

    public static Type getEGLType(String primSignature, int length) {
        String sig = String.valueOf(primSignature) + "(" + length + ")";
        return IRUtils.getEGLType(sig);
    }

    public static Type getEGLType(String primSignature, String pattern) {
        String sig = String.valueOf(primSignature) + "(" + pattern + ")";
        return IRUtils.getEGLType(sig);
    }

    public static StructPart getEGLPrimitiveType(String primSignature) {
        return (StructPart)IRUtils.getEGLType(primSignature);
    }

    public static FixedPrecisionType getEGLPrimitiveType(String primSignature, int length, int decimals) {
        return (FixedPrecisionType)IRUtils.getEGLType(primSignature, length, decimals);
    }

    public static SequenceType getEGLPrimitiveType(String primSignature, int length) {
        return (SequenceType)IRUtils.getEGLType(primSignature, length);
    }

    public static PatternType getEGLPrimitiveType(String primSignature, String pattern) {
        return (PatternType)IRUtils.getEGLType(primSignature, pattern);
    }

    public static void markOverloadedFunctions(LogicAndDataPart part) {
        ArrayList<Function> overloaded = new ArrayList<Function>();
        for (Function func : part.getFunctions()) {
            for (Function possible : part.getFunctions()) {
                if (func == possible || overloaded.contains(func) || !func.getName().equalsIgnoreCase(possible.getName())) continue;
                overloaded.add(func);
            }
        }
        ArrayList<Function> parmLengthSame = new ArrayList<Function>();
        for (Function func : overloaded) {
            for (Function possible : overloaded) {
                if (func == possible || parmLengthSame.contains(func) || func.getParameters().size() != possible.getParameters().size()) continue;
                parmLengthSame.add(func);
            }
        }
        for (Function func : parmLengthSame) {
            boolean shouldMark = false;
            for (Function possible : parmLengthSame) {
                shouldMark = false;
                if (func == possible) continue;
                int j = 0;
                for (FunctionParameter parm : possible.getParameters()) {
                    boolean bl = shouldMark = parm.getParameterKind() == ParameterKind.PARM_INOUT || parm.getParameterKind() == ParameterKind.PARM_OUT;
                    if (shouldMark && j < func.getParameters().size()) {
                        FunctionParameter p = func.getParameters().get(j);
                        boolean bl2 = shouldMark = p.getParameterKind() == ParameterKind.PARM_INOUT || p.getParameterKind() == ParameterKind.PARM_OUT;
                    }
                    if (shouldMark) break;
                    ++j;
                }
                if (shouldMark) break;
            }
            if (!shouldMark) continue;
            Annotation ann = factory.createAnnotation(OVERLOADED_FUNCTION);
            func.addAnnotation(ann);
        }
    }

    public static boolean isOverloadedFunction(Function func) {
        return func.getAnnotation(OVERLOADED_FUNCTION) != null;
    }

    public static void makeCompatible(BinaryExpression expr) {
        Type type1 = expr.getLHS().getType();
        Type type2 = expr.getRHS().getType();
        if (type1 != null && type2 != null) {
            IRUtils.makeCompatible(expr, type1, type2);
        }
    }

    public static void makeCompatible(BinaryExpression expr, Type type1, Type type2) {
        Expression asExpr;
        if (IRUtils.isNull(type1) || IRUtils.isNull(type2)) {
            return;
        }
        Operation op = expr.getOperation();
        Type parmType1 = op.getParameters().get(0).getType();
        Type parmType2 = op.getParameters().get(1).getType();
        if (type1 != null && !type1.getClassifier().equals(parmType1).booleanValue()) {
            asExpr = IRUtils.makeExprCompatibleToType(expr.getLHS(), parmType1);
            expr.setLHS(asExpr);
        }
        if (type2 != null && !type2.getClassifier().equals(parmType2).booleanValue()) {
            asExpr = IRUtils.makeExprCompatibleToType(expr.getRHS(), parmType2);
            expr.setRHS(asExpr);
        }
    }

    public static void makeCompatible(Assignment expr) {
        Type type = expr.getLHS().getType();
        Expression asExpr = IRUtils.makeExprCompatibleToType(expr.getRHS(), type);
        expr.setRHS(asExpr);
    }

    public static void makeCompatible(Assignment expr, Type type) {
        Expression asExpr = IRUtils.makeExprCompatibleToType(expr.getRHS(), type);
        expr.setRHS(asExpr);
    }

    public static void makeCompatible(InvocationExpression expr) {
        int i = 0;
        for (Expression arg : expr.getArguments()) {
            Expression asExpr = IRUtils.makeExprCompatibleToType(arg, expr.getParameterTypeForArg(i));
            expr.getArguments().set(i, asExpr);
            ++i;
        }
    }

    private static boolean isList(Classifier clazz) {
        if (clazz != null) {
            return clazz.getMofSerializationKey().equalsIgnoreCase("egl:eglx.lang.EList");
        }
        return false;
    }

    private static boolean isString(NamedElement clazz) {
        if (clazz instanceof Classifier) {
            return ((Classifier)clazz).getMofSerializationKey().equalsIgnoreCase("egl:eglx.lang.EString");
        }
        return false;
    }

    private static boolean isNull(Type type) {
        if (type == null || type.getMofSerializationKey() == null) {
            return false;
        }
        return type.getMofSerializationKey().equalsIgnoreCase("egl:eglx.lang.NullType");
    }

    private static boolean isAny(Classifier clazz) {
        if (clazz != null) {
            return clazz.getMofSerializationKey().equalsIgnoreCase("egl:eglx.lang.EAny");
        }
        return false;
    }

    public static Expression makeExprCompatibleToType(Expression expr, Type type) {
        BoxingExpression box;
        NamedElement mbr;
        Type exprType = expr.getType();
        if (exprType instanceof ArrayType && ((ArrayType)exprType).getElementType() instanceof GenericType && ((ArrayType)exprType).getElementType().getClassifier() == null) {
            return expr;
        }
        if (expr instanceof TernaryExpression) {
            TernaryExpression tern = (TernaryExpression)expr;
            tern.setSecond(IRUtils.makeExprCompatibleToType(tern.getSecond(), type));
            tern.setThird(IRUtils.makeExprCompatibleToType(tern.getThird(), type));
        }
        if (expr instanceof Name && (mbr = ((Name)expr).getNamedElement()) instanceof Function) {
            return expr;
        }
        if (expr instanceof NullLiteral) {
            return expr;
        }
        if (IRUtils.isNull(type)) {
            return expr;
        }
        if (type instanceof ArrayType && exprType instanceof ArrayType && (!type.equals(exprType).booleanValue() || ((ArrayType)type).elementsNullable() != ((ArrayType)exprType).elementsNullable())) {
            return IRUtils.createAsExpression(expr, type);
        }
        if (exprType.equals(type).booleanValue() || exprType.getClassifier().equals(type).booleanValue()) {
            return expr;
        }
        if (IRUtils.isList(type.getClassifier()) && (exprType.equals(type.getClassifier()).booleanValue() || exprType.getClassifier().equals(type.getClassifier()).booleanValue())) {
            return expr;
        }
        if (exprType.getClassifier().equals(type.getClassifier()).booleanValue()) {
            if (exprType instanceof SequenceType && type instanceof SequenceType) {
                if (((SequenceType)exprType).getLength() < ((SequenceType)type).getLength()) {
                    return expr;
                }
            } else if (exprType instanceof FixedPrecisionType && type instanceof FixedPrecisionType) {
                FixedPrecisionType fpExpr = (FixedPrecisionType)exprType;
                FixedPrecisionType fpType = (FixedPrecisionType)type;
                if (fpExpr.getLength() <= fpType.getLength() && fpExpr.getDecimals() <= fpType.getDecimals()) {
                    return expr;
                }
            }
        }
        if (TypeUtils.isReferenceType(exprType) && exprType instanceof SubType && type instanceof StructPart && ((SubType)((Object)exprType)).isSubtypeOf((StructPart)type) && (IRUtils.isAny(type.getClassifier()) || type.equals(IRUtils.getEGLPrimitiveType("eglx.lang.ENumber")).booleanValue())) {
            return IRUtils.createAsExpression(expr, type);
        }
        if (TypeUtils.isReferenceType(type) && TypeUtils.isValueType(exprType) && !(type instanceof ParameterizableType) && type != IRUtils.getEGLPrimitiveType("eglx.lang.ENumber")) {
            box = factory.createBoxingExpression();
            box.setExpr(expr);
            return IRUtils.createAsExpression((Expression)box, type);
        }
        if (IRUtils.isAny(type.getClassifier()) && IRUtils.isList(exprType.getClassifier())) {
            box = factory.createBoxingExpression();
            box.setExpr(expr);
            return box;
        }
        return IRUtils.createAsExpression(expr, type);
    }

    public static AsExpression createAsExpression(Expression objExpr, Type target) {
        AsExpression expr = factory.createAsExpression();
        expr.setObjectExpr(objExpr);
        expr.setEType(target);
        expr.setConversionOperation(IRUtils.getConversionOperation(objExpr, target));
        Annotation annot = objExpr.getAnnotation("EGL_Location");
        if (annot != null) {
            expr.addAnnotation(annot);
        }
        return expr;
    }

    public static AsExpression createAsExpression(Expression objExpr, ParameterizableType target) {
        ParameterizedType type = (ParameterizedType)target.getParameterizedType().newInstance();
        type.setParameterizableType(target);
        AsExpression expr = IRUtils.createAsExpression(objExpr, type);
        return expr;
    }

    public static Integer conversionDirection(NamedElement lhsne, NamedElement rhsne, String operator) {
        if (lhsne == null || rhsne == null) {
            return 0;
        }
        if (lhsne.equals(rhsne)) {
            return 0;
        }
        if (lhsne instanceof Type && rhsne instanceof Type) {
            Type lhs = (Type)((Object)lhsne);
            Type rhs = (Type)((Object)rhsne);
            if (lhs.equals(rhs).booleanValue() || lhs.getClassifier().equals(rhs.getClassifier()).booleanValue()) {
                return 0;
            }
            if (operator.equals("+") && TypeUtils.isNumericType(lhs) && TypeUtils.isTextType(rhs)) {
                return 2;
            }
            if (operator.equals("+") && TypeUtils.isTextType(lhs)) {
                return -1;
            }
            if (IRUtils.isValidWidenConversion(lhs, rhs)) {
                return 1;
            }
            if (IRUtils.isValidWidenConversion(rhs, lhs)) {
                return -1;
            }
            if (IRUtils.isValidNarrowConversion(lhs, rhs)) {
                return 1;
            }
            if (IRUtils.isValidNarrowConversion(rhs, lhs)) {
                return -1;
            }
            return null;
        }
        return null;
    }

    public static boolean isValidWidenConversion(Type source, Type target) {
        Classifier c2;
        Classifier c1 = source.getClassifier();
        if (c1 == (c2 = target.getClassifier())) {
            return true;
        }
        if (c1 instanceof StructPart && c2 instanceof StructPart) {
            StructPart src = (StructPart)c1;
            StructPart trg = (StructPart)c2;
            Operation op = TypeUtils.getBestFitWidenConversionOp(src, trg);
            return op != null || src.isSubtypeOf(trg);
        }
        return false;
    }

    public static boolean isValidNarrowConversion(Type source, Type target) {
        Classifier c2;
        Classifier c1 = source.getClassifier();
        if (c1 == (c2 = target.getClassifier())) {
            return true;
        }
        if (c1 instanceof StructPart && c2 instanceof StructPart) {
            StructPart src = (StructPart)c1;
            StructPart trg = (StructPart)c2;
            Operation op = TypeUtils.getBestFitNarrowConversionOp(src, trg);
            return op != null;
        }
        return false;
    }

    public static StructPart getCommonSupertype(Type type1, Type type2) {
        if (type1.getClassifier() instanceof StructPart && type2.getClassifier() instanceof StructPart) {
            StructPart class1 = (StructPart)type1.getClassifier();
            StructPart class2 = (StructPart)type2.getClassifier();
            StructPart result = null;
            if (class1.equals(class2).booleanValue() || class2.isSubtypeOf(class1)) {
                result = class1;
            } else {
                for (StructPart superType : class1.getSuperTypes()) {
                    if (!IRUtils.isValidWidenConversion(type2, superType)) continue;
                    result = superType;
                    break;
                }
                if (result == null) {
                    for (StructPart superType : class1.getSuperTypes()) {
                        result = IRUtils.getCommonSupertype(superType, type2);
                        if (result != null) break;
                    }
                    if (result == null) {
                        result = IRUtils.getCommonSupertype(type2, type1);
                    }
                }
                if (result == null) {
                    result = (StructPart)TypeUtils.Type_ANY;
                }
            }
            return result;
        }
        return null;
    }

    public static Operation getConversionOperation(Expression expr, Type trg) {
        if (expr.getType() != null && expr.getType().getClassifier() instanceof StructPart && trg.getClassifier() instanceof StructPart && (StructPart)expr.getType().getClassifier() != (StructPart)trg.getClassifier()) {
            return IRUtils.getConversionOperation((StructPart)expr.getType().getClassifier(), (StructPart)trg.getClassifier());
        }
        return null;
    }

    public static Operation getConversionOperation(StructPart src, StructPart trg) {
        Operation op = TypeUtils.getBestFitWidenConversionOp(src, trg);
        if (op != null) {
            return op;
        }
        op = TypeUtils.getBestFitNarrowConversionOp(src, trg);
        return op;
    }

    public static Operation getMyOperation(Classifier classifier, String opSymbol) {
        if (!(classifier instanceof StructPart)) {
            return null;
        }
        StructPart clazz = (StructPart)classifier;
        for (Operation op : clazz.getOperations()) {
            if (!op.getOpSymbol().equals(opSymbol)) continue;
            return op;
        }
        return null;
    }

    private static Operation getNoConversionBinaryOperation(NamedElement lhs, NamedElement rhs, StructPart clazz, String opSymbol) {
        if (!lhs.equals(rhs)) {
            Operation result = IRUtils.primGetNoConversionBinaryOperation(lhs, rhs, clazz, opSymbol);
            if (result != null) {
                return result;
            }
            if (clazz != lhs && lhs instanceof StructPart && (result = IRUtils.primGetNoConversionBinaryOperation(lhs, rhs, (StructPart)lhs, opSymbol)) != null) {
                return result;
            }
            if (clazz != rhs && rhs instanceof StructPart && (result = IRUtils.primGetNoConversionBinaryOperation(lhs, rhs, (StructPart)rhs, opSymbol)) != null) {
                return result;
            }
        }
        return null;
    }

    private static Operation primGetNoConversionBinaryOperation(NamedElement lhs, NamedElement rhs, StructPart clazz, String opSymbol) {
        List<Operation> ops = TypeUtils.getBestFitOperation(clazz, opSymbol, lhs, rhs);
        if (ops.size() > 0) {
            for (Operation operation : ops) {
                if (operation.getParameters().get(0).getType().equals(operation.getParameters().get(1).getType()).booleanValue() || !IRUtils.argTypeCompatibleWithParms(operation, lhs, rhs)) continue;
                return operation;
            }
        }
        return null;
    }

    private static StructPart getCommonSuperType(NamedElement lhs, NamedElement rhs) {
        if (!(rhs instanceof SubType)) {
            return null;
        }
        if (!(lhs instanceof SubType)) {
            return null;
        }
        SubType lhsSub = (SubType)((Object)lhs);
        SubType rhsSub = (SubType)((Object)rhs);
        if (lhs instanceof StructPart && rhsSub.isSubtypeOf((StructPart)lhs)) {
            return (StructPart)lhs;
        }
        if (rhs instanceof StructPart && lhsSub.isSubtypeOf((StructPart)rhs)) {
            return (StructPart)rhs;
        }
        for (StructPart superType : lhsSub.getSuperTypes()) {
            if (!rhsSub.isSubtypeOf(superType)) continue;
            return superType;
        }
        for (StructPart superType : rhsSub.getSuperTypes()) {
            if (!lhsSub.isSubtypeOf(superType)) continue;
            return superType;
        }
        return null;
    }

    public static Operation getBinaryOperation(NamedElement lhs, NamedElement rhs, String opSymbol) {
        Operation result = IRUtils.primGetBinaryOperation(lhs, rhs, opSymbol);
        if (result != null) {
            return result;
        }
        result = IRUtils.checkForTextConcatenation(lhs, opSymbol);
        if (result != null) {
            return result;
        }
        result = IRUtils.checkForTextConcatenation(rhs, opSymbol);
        if (result != null) {
            return result;
        }
        StructPart commonSuper = IRUtils.getCommonSuperType(lhs, rhs);
        if (commonSuper != null) {
            return IRUtils.getBinaryOperation(commonSuper, commonSuper, opSymbol);
        }
        return result;
    }

    private static Operation checkForTextConcatenation(NamedElement clazz, String opSymbol) {
        if ((opSymbol.equals("+") || opSymbol.equals("::") || opSymbol.equals("?:")) && IRUtils.isString(clazz)) {
            return TypeUtils.getBinaryOperation((StructPart)clazz, opSymbol, false);
        }
        return null;
    }

    private static Operation primGetBinaryOperation(NamedElement lhs, NamedElement rhs, String opSymbol) {
        if (!(lhs instanceof StructPart)) {
            Operation result = null;
            if (rhs instanceof StructPart && (result = IRUtils.getNoConversionBinaryOperation(lhs, rhs, (StructPart)rhs, opSymbol)) != null) {
                return result;
            }
            if (lhs instanceof SubType) {
                SubType lSubType = (SubType)((Object)lhs);
                NamedElement rSubType = rhs;
                if (!(rhs instanceof StructPart) && rhs instanceof SubType && ((SubType)((Object)rhs)).getSuperTypes().size() > 0) {
                    rSubType = ((SubType)((Object)rhs)).getSuperTypes().get(0);
                }
                if (lSubType.getSuperTypes().size() > 0) {
                    return IRUtils.getBinaryOperation(lSubType.getSuperTypes().get(0), rSubType, opSymbol);
                }
            }
            return null;
        }
        StructPart clazz = null;
        Integer direction = IRUtils.conversionDirection(lhs, rhs, opSymbol);
        Operation conOp = null;
        if (direction == null || direction == 0) {
            clazz = (StructPart)lhs;
        } else if (direction == -1) {
            conOp = IRUtils.getConversionOperation((StructPart)rhs, (StructPart)lhs);
            if (conOp == null) {
                return IRUtils.getNoConversionBinaryOperation(lhs, rhs, (StructPart)lhs, opSymbol);
            }
            clazz = (StructPart)conOp.getType().getClassifier();
        } else if (direction == 1) {
            conOp = IRUtils.getConversionOperation((StructPart)lhs, (StructPart)rhs);
            if (conOp == null) {
                return null;
            }
            clazz = (StructPart)conOp.getType().getClassifier();
        } else if (direction == 2) {
            clazz = (StructPart)TypeUtils.Type_DECIMAL;
        }
        Operation result = IRUtils.getNoConversionBinaryOperation(lhs, rhs, clazz, opSymbol);
        if (result != null) {
            return result;
        }
        result = TypeUtils.getBinaryOperation(clazz, opSymbol, direction != null && direction == 0);
        if (IRUtils.argTypeCompatibleWithParms(result, lhs, rhs)) {
            return result;
        }
        result = null;
        if (result == null && direction != null) {
            if (direction == -1) {
                conOp = IRUtils.getConversionOperation((StructPart)lhs, (StructPart)rhs);
                if (conOp == null) {
                    return null;
                }
                clazz = (StructPart)conOp.getType().getClassifier();
            } else if (direction == 1) {
                conOp = IRUtils.getConversionOperation((StructPart)rhs, (StructPart)lhs);
                if (conOp == null) {
                    return null;
                }
                clazz = (StructPart)conOp.getType().getClassifier();
            }
            result = TypeUtils.getBinaryOperation(clazz, opSymbol, false);
        }
        if (IRUtils.argTypeCompatibleWithParms(result, lhs, rhs)) {
            return result;
        }
        return null;
    }

    private static boolean argTypeCompatibleWithParms(Operation operation, NamedElement lhs, NamedElement rhs) {
        if (operation == null) {
            return false;
        }
        return operation.getParameters().get(0).isGenericTypeParameter() || TypeUtils.areCompatible(operation.getParameters().get(0).getType().getClassifier(), lhs) && operation.getParameters().get(1).isGenericTypeParameter() || TypeUtils.areCompatible(operation.getParameters().get(1).getType().getClassifier(), rhs);
    }

    public static Operation getUnaryOperation(Classifier src, String opSymbol) {
        if (!(src instanceof StructPart)) {
            return null;
        }
        for (Operation op : ((StructPart)src).getOperations()) {
            if (!op.getOpSymbol().equals(opSymbol) || op.getParameters().size() != 1) continue;
            return op;
        }
        return null;
    }

    public static Operation getOperation(Classifier src, String opSymbol) {
        if (!(src instanceof StructPart)) {
            return null;
        }
        for (Operation op : ((StructPart)src).getOperations()) {
            if (!op.getOpSymbol().equals(opSymbol)) continue;
            return op;
        }
        return null;
    }

    public static String concatWithSeparator(String[] fragments, String separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < fragments.length) {
            result.append(fragments[i]);
            if (i < fragments.length - 1) {
                result.append(separator);
            }
            ++i;
        }
        return result.toString();
    }

    public void resolveTopLevelFunctionsAndDanglingReferences(LogicAndDataPart part) {
        TopLevelFunctionResolver resolver = new TopLevelFunctionResolver();
        for (Function func : part.getFunctions()) {
            resolver.resolveInContext(func, part);
        }
        resolver.resolveAddedFunctions(part);
    }

    public static void resolveDanglingReference(DanglingReference dangling, LogicAndDataPart part) throws NoSuchFieldError, AmbiguousReferenceException {
        Field field = part.getField(dangling.getId());
        if (field != null) {
            dangling.setMember(field);
        } else {
            Name expr;
            Field qualifier = null;
            EList fields = new EList();
            for (Field f : part.getFields()) {
                if (!(f.getType() instanceof LogicAndDataPart) && !(f.getType() instanceof StructuredContainer)) continue;
                qualifier = f;
                Container container = (Container)((Object)f.getType());
                if (container instanceof StructPart) {
                    List<StructuredField> list = ((StructPart)container).getStructuredFields(dangling.getId());
                    if (list.isEmpty()) continue;
                    fields.addAll(list);
                    continue;
                }
                Field fi = ((LogicAndDataPart)container).getField(dangling.getId());
                if (fi == null) continue;
                fields.add(fi);
            }
            for (Part usedPart : part.getUsedParts()) {
                List<StructuredField> list;
                if (usedPart instanceof LogicAndDataPart) {
                    for (Field f : ((LogicAndDataPart)usedPart).getFields()) {
                        if (!f.getName().equalsIgnoreCase(dangling.getId())) continue;
                        fields.add(f);
                    }
                }
                if (!(usedPart instanceof StructPart) || (list = ((StructPart)usedPart).getStructuredFields(dangling.getId())).isEmpty()) continue;
                fields.addAll(list);
            }
            if (fields.size() > 1) {
                throw new AmbiguousReferenceException(dangling.getId());
            }
            if (fields.size() == 0) {
                throw new NoSuchFieldError(dangling.getId());
            }
            if (qualifier instanceof Field) {
                expr = factory.createMemberName();
                expr.setId(qualifier.getId());
                expr.setMember(qualifier);
                dangling.setQualifier(expr);
            } else if (qualifier instanceof Part) {
                expr = factory.createPartName();
                expr.setId(((Part)((Object)qualifier)).getId());
                expr.setPackageName(((Part)((Object)qualifier)).getPackageName());
                dangling.setQualifier(expr);
            }
        }
    }

    public static Function resolveFunctionPartReference(FunctionPartInvocation expr, LogicAndDataPart part) {
        Function func = part.getFunction(expr.getId());
        if (func == null) {
            FunctionPart funcPart = expr.getFunctionPart();
            if (funcPart != null) {
                func = (Function)funcPart.getFunction().clone();
                expr.setTarget(func);
                return func;
            }
        } else {
            expr.setTarget(func);
        }
        return null;
    }

    public static Set<Part> getReferencedPartsFor(Part part) {
        return new PartsReferencedResolver().getReferencedPartsFor(part);
    }

    public static Constructor resolveConstructorReference(EGLClass clazz, List<Expression> arguments) {
        return IRUtils.resolveConstructorReference(clazz, arguments, true);
    }

    public static Constructor resolveConstructorReference(EGLClass clazz, List<Expression> arguments, boolean createDefault) {
        ArrayList<NamedElement> list = new ArrayList<NamedElement>();
        for (Expression expr : arguments) {
            list.add(IRUtils.getOperandType(expr));
        }
        return IRUtils.resolveConstructorReferenceFromArgTypes(clazz, list, createDefault);
    }

    public static Constructor resolveConstructorReferenceFromArgTypes(EGLClass clazz, List<NamedElement> arguments, boolean createDefault) {
        Constructor result = null;
        ArrayList<Constructor> possibles = new ArrayList<Constructor>();
        for (Constructor mbr : clazz.getConstructors()) {
            if (mbr.getParameters().size() != arguments.size()) continue;
            boolean exact = true;
            int i = 0;
            while (i < arguments.size()) {
                if (!(arguments.get(i) instanceof Type) || !mbr.getParameters().get(i).getType().equals((Type)((Object)arguments.get(i))).booleanValue()) {
                    exact = false;
                }
                ++i;
            }
            if (exact) {
                return mbr;
            }
            boolean compat = false;
            int i2 = 0;
            while (i2 < arguments.size()) {
                compat = IRUtils.isCompatibleWith(arguments.get(i2), mbr.getParameters().get(i2).getType());
                ++i2;
            }
            if (!compat) continue;
            possibles.add(mbr);
        }
        if (possibles.size() == 0) {
            if (createDefault) {
                result = IrFactory.INSTANCE.createConstructor();
                result.setIsAbstract(true);
                result.setName(clazz.getName());
                result.setType(clazz);
            }
        } else {
            result = possibles.size() == 1 ? (Constructor)possibles.get(0) : (Constructor)possibles.get(0);
        }
        return result;
    }

    private static NamedElement getOperandType(Expression expr) {
        if (expr instanceof Name && ((Name)expr).getNamedElement() instanceof Function) {
            return (Function)((Name)expr).getNamedElement();
        }
        return expr.getType().getClassifier();
    }

    public static boolean isCompatibleWith(Expression expr, Type type) {
        NamedElement exprKind = IRUtils.getOperandType(expr);
        return TypeUtils.areCompatible(type.getClassifier(), exprKind);
    }

    public static boolean isCompatibleWith(NamedElement opType, Type type) {
        return TypeUtils.areCompatible(type.getClassifier(), opType);
    }

    public static boolean isMoveCompatible(Type lhsType, Member lhsMember, Type rhsType, Member rhsMember) {
        if (rhsMember == null && rhsType == null || lhsMember == null && lhsType == null) {
            return true;
        }
        if (rhsType != null && lhsMember != null && TypeUtils.Type_NULLTYPE.equals(rhsType).booleanValue()) {
            return lhsMember.isNullable();
        }
        return IRUtils.isMoveCompatible(lhsType, rhsType, rhsMember);
    }

    public static boolean isMoveCompatible(Type lhsType, Type rhsType, Member rhsMember) {
        if (rhsMember == null && rhsType == null || lhsType == null) {
            return true;
        }
        if (rhsType != null) {
            if (lhsType instanceof ArrayType && rhsType instanceof ArrayType) {
                return IRUtils.areArraysCompatible((ArrayType)lhsType, (ArrayType)rhsType);
            }
            return TypeUtils.areCompatible(lhsType.getClassifier(), rhsType.getClassifier());
        }
        return TypeUtils.areCompatible(lhsType.getClassifier(), rhsMember);
    }

    private static boolean areArraysCompatible(ArrayType type1, ArrayType type2) {
        Type elementType1 = type1.getElementType();
        Type elementType2 = type2.getElementType();
        if (!type1.elementsNullable() && elementType1.equals(TypeUtils.Type_NULLTYPE).booleanValue()) {
            return true;
        }
        if (!type2.elementsNullable() && elementType2.equals(TypeUtils.Type_NULLTYPE).booleanValue()) {
            return true;
        }
        if (elementType1.equals(TypeUtils.Type_NULLTYPE).booleanValue() && type1.elementsNullable() || elementType2.equals(TypeUtils.Type_NULLTYPE).booleanValue() && type2.elementsNullable()) {
            return type1.elementsNullable() == type2.elementsNullable();
        }
        if (elementType1 instanceof ParameterizedType) {
            elementType1 = ((ParameterizedType)elementType1).getParameterizableType();
        }
        if (elementType2 instanceof ParameterizedType) {
            elementType2 = ((ParameterizedType)elementType2).getParameterizableType();
        }
        if (elementType1 == null || elementType2 == null) {
            return true;
        }
        if (elementType1 instanceof ArrayType && elementType2 instanceof ArrayType) {
            return IRUtils.areArraysCompatible((ArrayType)elementType1, (ArrayType)elementType2);
        }
        return TypeUtils.areCompatible(elementType1.getClassifier(), elementType2.getClassifier());
    }

    public static String getFileName(EObject obj) {
        FileNameResolver resolver = new FileNameResolver(obj);
        return resolver.getFilename();
    }

    public static String getQualifiedFileName(EObject obj) {
        FileNameResolver resolver = new FileNameResolver(obj);
        String fileName = resolver.getFilename();
        String packageName = resolver.getPackage();
        if (fileName == null || packageName == null) {
            return null;
        }
        if (packageName.length() == 0) {
            return fileName;
        }
        return String.valueOf(packageName.replace('.', '/')) + "/" + fileName;
    }

    public static boolean isSystemPart(String partName, IEnvironment sysIREnv) {
        String key = IRUtils.makeEGLKey(partName);
        return sysIREnv.get(key) != null;
    }

    public static String makeEGLKey(String key) {
        if (key != null && !key.startsWith(EGL_SCHEMA)) {
            key = String.valueOf(EGL_SCHEMA) + key;
        }
        return key.toUpperCase().toLowerCase();
    }

    public static class FileNameResolver
    extends AbstractVisitor {
        private String packageName;
        private String fileName;

        FileNameResolver(EObject obj) {
            this.disallowRevisit();
            obj.accept((EVisitor)this);
        }

        private String getFilename() {
            return this.fileName;
        }

        private String getPackage() {
            return this.packageName;
        }

        public boolean visit(Object obj) {
            return false;
        }

        public boolean visit(Classifier classifier) {
            int i;
            this.fileName = classifier.getFileName();
            if (this.fileName != null && (i = this.fileName.lastIndexOf("/")) >= 0) {
                this.fileName = this.fileName.substring(i + 1);
            }
            this.packageName = classifier.getPackageName();
            return false;
        }

        public boolean visit(Statement stmt) {
            if (stmt.getContainer() != null) {
                stmt.getContainer().accept((EVisitor)this);
            }
            return false;
        }

        public boolean visit(Member mbr) {
            if (mbr.getContainer() != null) {
                mbr.getContainer().accept((EVisitor)this);
            }
            return false;
        }
    }

    public static class PartsReferencedResolver
    extends AbstractVisitor {
        Part root;
        Set<Part> referencedParts;

        PartsReferencedResolver() {
            this.disallowRevisit();
            this.referencedParts = new HashSet<Part>();
        }

        public boolean visit(Part part) {
            if (part == this.root) {
                return true;
            }
            this.referencedParts.add(part);
            return false;
        }

        public boolean visit(TypeName name) {
            name.getType().accept((EVisitor)this);
            return false;
        }

        public boolean visit(NewExpression newExpr) {
            newExpr.getType().accept((EVisitor)this);
            return true;
        }

        public boolean visit(Member member) {
            if (member.getContainer() instanceof Part && member.getContainer() != this.root) {
                member.getContainer().accept((EVisitor)this);
                return false;
            }
            return true;
        }

        public Set<Part> getReferencedPartsFor(Part part) {
            this.root = part;
            this.root.accept((EVisitor)this);
            return this.referencedParts;
        }
    }

    public class TopLevelFunctionResolver
    extends AbstractVisitor {
        private LogicAndDataPart context;
        private Function currentFunction;
        private Set<Function> addedFunctions = new HashSet<Function>();

        TopLevelFunctionResolver() {
            this.disallowRevisit();
        }

        public void resolveInContext(Function func, LogicAndDataPart part) {
            this.context = part;
            func.accept((EVisitor)this);
            this.currentFunction = null;
            this.context = null;
        }

        public void resolveAddedFunctions(LogicAndDataPart part) {
            ArrayList<Function> newFunctions = new ArrayList<Function>();
            newFunctions.addAll(this.addedFunctions);
            this.addedFunctions = new HashSet<Function>();
            for (Function func : newFunctions) {
                part.addMember(func);
            }
            for (Function func : newFunctions) {
                this.resolveInContext(func, part);
            }
            if (!this.addedFunctions.isEmpty()) {
                this.resolveAddedFunctions(part);
            }
        }

        public boolean visit(Member mbr) {
            return false;
        }

        public boolean visit(Part part) {
            return false;
        }

        public boolean visit(Function func) {
            if (this.currentFunction == null) {
                this.currentFunction = func;
                for (Statement stmt : func.getStatementBlock().getStatements()) {
                    stmt.accept((EVisitor)this);
                }
            }
            return false;
        }

        public boolean visit(DanglingReference ref) {
            try {
                IRUtils.resolveDanglingReference(ref, this.context);
            }
            catch (NoSuchFieldError e) {
                throw new RuntimeException(e);
            }
            catch (AmbiguousReferenceException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        public boolean visit(FunctionPartInvocation expr) {
            Function f = null;
            for (Function added : this.addedFunctions) {
                if (!added.getName().equalsIgnoreCase(expr.getId())) continue;
                f = added;
                break;
            }
            if (f == null) {
                f = IRUtils.resolveFunctionPartReference(expr, this.context);
                if (f != null) {
                    this.addedFunctions.add(f);
                }
                for (Expression parm : expr.getArguments()) {
                    parm.accept((EVisitor)this);
                }
            }
            return false;
        }
    }
}

